unit uMain;

{$mode objfpc}{$H+}

interface

uses
 Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

 { TForm1 }

  tmyformatthread = class(tthread)
  protected
    procedure execute; override;
  private
    time_: string;
    mySettings: TFormatSettings;
    procedure syncMain;
  end;

 TForm1 = class(TForm)
  Button1: TButton;
  Button2: TButton;
  Label1: TLabel;
  procedure Button1Click(Sender: TObject);
  procedure Button2Click(Sender: TObject);
  procedure FormCreate(Sender: TObject);
 private
  //mySettings: TFormatSettings;
 public
  th: tmyformatthread;
 end;

 { tmyformatthread }

var
 Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
begin
  th:=tmyformatthread.Create(False);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 if Assigned(th) then
   begin
     th.Terminate;
     th.WaitFor;
     FreeAndNil(th);
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  th:=nil;
  //mySettings.DateSeparator:='.';
  //mySettings.TimeSeparator:=':';
  //mySettings.LongDateFormat:='dd.mm.yyyy';
  //mySettings.ShortDateFormat:='dd.mm.yyyy';
  //mySettings.LongTimeFormat:='hh:nn:ss';
  //mySettings.ShortTimeFormat:='hh:nn';
  //mySettings.DecimalSeparator:='.';
end;

{ tmyformatthread }

procedure tmyformatthread.execute;
begin
  mySettings.DateSeparator:='.';
  mySettings.TimeSeparator:=':';
  mySettings.LongDateFormat:='dd.mm.yyyy';
  mySettings.ShortDateFormat:='dd.mm.yyyy';
  mySettings.LongTimeFormat:='hh:nn:ss';
  mySettings.ShortTimeFormat:='hh:nn';
  mySettings.DecimalSeparator:='.';
 while not terminated do
   begin
     time_:=formatdatetime('dd.mm.yyyy hh:nn:ss', Now, mySettings);
     Synchronize(@syncMain);
     Sleep(1000);
   end;
end;

procedure tmyformatthread.syncMain;
begin
  Form1.Label1.Caption:=time_;
end;

end.
