{******************************************************************************}
{ Projeto: FortesReport Community Edition                                      }
{  um poderoso gerador de relatrios disponvel como um pacote de componentes }
{ para Delphi. Em FortesReport, os relatrios so constitudos por bandas que  }
{ tm funes especficas no fluxo de impresso. Voc definir agrupamentos     }
{ subnveis e totais simplesmente pela relao hierrquica entre as bandas.    }
{ Alm disso possui uma rica paleta de Componentes                             }
{                                                                              }
{ Direitos Autorais Reservados(c) Copyright  1999-2015 Fortes Informtica     }
{                                                                              }
{ Colaboradores nesse arquivo: Ronaldo Moreira                                 }
{                              Mrcio Martins                                  }
{                              Rgys Borges da Silveira                        }
{                              Juliomar Marchetti                              }
{                                                                              }
{  Voc pode obter a ltima verso desse arquivo na pagina do Projeto          }
{  localizado em                                                               }
{ https://github.com/fortesinformatica/fortesreport-ce                         }
{                                                                              }
{  Para mais informaes voc pode consultar o site www.fortesreport.com.br ou }
{  no Yahoo Groups https://groups.yahoo.com/neo/groups/fortesreport/info       }
{                                                                              }
{  Esta biblioteca  software livre; voc pode redistribu-la e/ou modific-la }
{ sob os termos da Licena Pblica Geral Menor do GNU conforme publicada pela  }
{ Free Software Foundation; tanto a verso 2.1 da Licena, ou (a seu critrio) }
{ qualquer verso posterior.                                                   }
{                                                                              }
{  Esta biblioteca  distribuda na expectativa de que seja til, porm, SEM   }
{ NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU      }
{ ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral Menor}
{ do GNU para mais detalhes. (Arquivo LICENA.TXT ou LICENSE.TXT)              }
{                                                                              }
{  Voc deve ter recebido uma cpia da Licena Pblica Geral Menor do GNU junto}
{ com esta biblioteca; se no, escreva para a Free Software Foundation, Inc.,  }
{ no endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.          }
{ Voc tambm pode obter uma copia da licena em:                              }
{ http://www.opensource.org/licenses/gpl-license.php                           }
{                                                                              }
{******************************************************************************}

{******************************************************************************
|* Historico
|*
|* xx/xx/xxxx:  Autor...
|* - Descrio...
******************************************************************************}

{$I RLReport.inc}

{@unit RLConsts - Variveis de internacionalizao e variveis de configurao. }
unit RLConsts;

interface

uses
  Classes,
  {$IfDef CLX}
   QDialogs,
  {$Else}
   Dialogs,
  {$EndIf}
  SysUtils ;

const
  {@const ScreenPPI - Resoluo do monitor em pixels por polegada.
   Representa a quantidade de pixels por polegada do vdeo. O valor real varia de monitor para monitor mas,
   para facilitar clculos e tornar os projetos independentes do terminal, essa valor  assumido como sendo 96. :/}
  ScreenPPI = 96;

  {@const InchAsMM - Fator de converso de polegada para milmetros.
   Este fator  utilizado em diversos pontos para converses de coordenadas. :/}
  InchAsMM = 254 / 10;

  {@const MMAsPixels - Fator de converso de milmetros para pixels de tela.
   @links ScreenPPI, InchAsMM. :/}
  MMAsPixels = ScreenPPI / InchAsMM;

  MaxPageNo = 999999;

  ReportFileExt = '.rpf';

  { constantes para exibio na inicializao e no sobre do delphi a partir da verso 2009 }
  cRLSobreDialogoTitulo = 'FortesReport Community Edition';
  cRLSobreTitulo = 'FortesReport Community Edition VCL';
  cRLSobreDescricao = 'FortesReport Community Edition VCL ' + #13#10 +
                      'http://www.fortesreport.com.br' + #13#10 +
                      'https://github.com/fortesinformatica/fortesreport-ce' + #13#10 +
                      'Componentes para Gerao de Relatrios' + #13#10 +
                      'Lesser General Public License version 2.0';
  cRLSobreLicencaStatus = 'LGPLv2';
  
  {****                                  *}	

const
  CS_CopyrightStr = 'Copyright  1999-2015 Fortes Informtica';
  CS_ProductTitleStr = 'FortesReport Community Edition';
  CS_URLStr = 'http://www.fortesreport.com.br';
  CS_AuthorNameStr = 'Ronaldo Moreira';
  CS_Version = '4.0';

type
  TRLLocaleStrings = record
    {@var LocaleStrings.LS_PrintingInProgressStr - Varivel de internacionalizao para "Imprimindo o relatrio..." :/}
    LS_PrintingInProgressStr: string;
    {@var LS_FilterInProgressStr - Varivel de internacionalizao para "Salvando o relatrio..." :/}
    LS_FilterInProgressStr: string;
    {@var LS_PreparingReportStr - Varivel de internacionalizao para "Preparando o relatrio..." :/}
    LS_PreparingReportStr: string;
    {@var LS_PrinterNotFoundStr - Varivel de internacionalizao para "Nenhuma impressora encontrada" :/}
    LS_PrinterNotFoundStr: string;
    {@var LS_NoPathToPrinterStr - Varivel de internacionalizao para "Caminho invlido para a impressora" :/}
    LS_NoPathToPrinterStr: string;
    {@var LS_LoadDefaultConfigStr - Varivel de internacionalizao para "Ser carregada a configurao padro" :/}
    LS_LoadDefaultConfigStr: string;
    {@var LS_PrinterDriverErrorStr - Varivel de internacionalizao para "Erro no driver da impressora" :/}
    LS_PrinterDriverErrorStr: string;
    {@var LS_PageStr - Varivel de internacionalizao para "Pgina" :/}
    LS_PageStr: string;
    {@var LS_PrepareErrorStr - Varivel de internacionalizao para "Erro durante a preparao do relatrio" :/}
    LS_PrepareErrorStr: string;
    {@var LS_PageBreakStr - Varivel de internacionalizao para "Continua..." :/}
    LS_PageBreakStr: string;
    {@var LS_PageMendStr - Varivel de internacionalizao para "Continuao" :/}
    LS_PageMendStr: string;
    {@var LS_ReportEndStr - Varivel de internacionalizao para "Fim" :/}
    LS_ReportEndStr: string;
    {@var LS_FileNotFoundStr - Varivel de internacionalizao para "Arquivo no encontrado" :/}
    LS_FileNotFoundStr: string;
    {@var LS_FileNameStr - Varivel de internacionalizao para "Nome do arquivo" :/}
    LS_FileNameStr: string;
    {@var LS_AllFileTypesStr - Varivel de internacionalizao para "Todos os arquivos" :/}
    LS_AllFileTypesStr: string;
    {@var LS_LoadReportStr - Varivel de internacionalizao para "Carregar relatrio" :/}
    LS_LoadReportStr: string;
    {@var LS_NotFoundStr - Varivel de internacionalizao para "No encontrado" :/}
    LS_NotFoundStr: string;
    {@var LS_WaitStr - Varivel de internacionalizao para "Aguarde..." :/}
    LS_WaitStr: string;
    {@var LS_FinishedStr - Varivel de internacionalizao para "Concludo" :/}
    LS_FinishedStr: string;
    {@var LS_CancelStr - Varivel de internacionalizao para "Cancelar" :/}
    LS_CancelStr: string;
    {@var LS_CloseStr - Varivel de internacionalizao para "Fechar" :/}
    LS_CloseStr: string;
    {@var LS_SaveStr - Varivel de internacionalizao para "Salvar" :/}
    LS_SaveStr: string;
    {@var LS_SendStr - Varivel de internacionalizao para "Enviar" :/}
    LS_SendStr: string;
    {@var LS_PrintStr - Varivel de internacionalizao para "Imprimir" :/}
    LS_PrintStr: string;
    {@var LS_AboutTheStr - Varivel de internacionalizao para "Sobre o" :/}
    LS_AboutTheStr: string;
    {@var LS_PreviewStr - Varivel de internacionalizao para "Pr-visualizao" :/}
    LS_PreviewStr: string;
    {@var LS_OfStr - Varivel de internacionalizao para "de" :/}
    LS_OfStr: string;
    {@var LS_ZoomStr - Varivel de internacionalizao para "Zoom" :/}
    LS_ZoomStr: string;
    {@var LS_FirstPageStr - Varivel de internacionalizao para "Primeira pgina" :/}
    LS_FirstPageStr: string;
    {@var LS_PriorPageStr - Varivel de internacionalizao para "Pgina anterior" :/}
    LS_PriorPageStr: string;
    {@var LS_NextPageStr - Varivel de internacionalizao para "Prxima pgina" :/}
    LS_NextPageStr: string;
    {@var LS_LastPageStr - Varivel de internacionalizao para "ltima pgina" :/}
    LS_LastPageStr: string;
    {@var LS_EntirePageStr - Varivel de internacionalizao para "Pgina inteira" :/}
    LS_EntirePageStr: string;
    {@var LS_EntireWidthStr - Varivel de internacionalizao para "Largura da pgina" :/}
    LS_EntireWidthStr: string;
    {@var LS_MultiplePagesStr - Varivel de internacionalizao para "Vrias pginas" :/}
    LS_MultiplePagesStr: string;
    {@var LS_ConfigPrinterStr - Varivel de internacionalizao para "Configurar impressora" :/}
    LS_ConfigPrinterStr: string;
    {@var LS_SaveToFileStr - Varivel de internacionalizao para "Salvar em disco" :/}
    LS_SaveToFileStr: string;
    {@var LS_SendToStr - Varivel de internacionalizao para "Enviar para" :/}
    LS_SendToStr: string;
    {@var LS_PrinterStr - Varivel de internacionalizao para "Impressora" :/}
    LS_PrinterStr: string;
    {@var LS_NameStr - Varivel de internacionalizao para "Nome" :/}
    LS_NameStr: string;
    {@var LS_PrintToFileStr - Varivel de internacionalizao para "Imprimir em arquivo" :/}
    LS_PrintToFileStr: string;
    {@var LS_PrintInBackgroundStr - Varivel de internacionalizao para "Imprimir em segundo plano" :/}
    LS_PrintInBackgroundStr: string;
    {@var LS_OptionsStr - Varivel de internacionalizao para "Opes" de filtragem. :/}
    LS_OptionsStr: string;
    {@var LS_SaveInBackground - Varivel de internacionalizao para "Salvar em segundo plano" :/}
    LS_SaveInBackground: string;
    {@var LS_PageRangeStr - Varivel de internacionalizao para "Intervalo de pginas" :/}
    LS_PageRangeStr: string;
    {@var LS_CopyAsImageStr - Varivel de internacionalizao para "Copiar como imagem" :/}
    LS_CopyAsImageStr: string;
    {@var LS_RangeFromStr - Varivel de internacionalizao para "de" :/}
    LS_RangeFromStr: string;
    {@var LS_RangeToStr - Varivel de internacionalizao para "at" :/}
    LS_RangeToStr: string;
    {@var LS_AllStr - Varivel de internacionalizao para "Tudo" :/}
    LS_AllStr: string;
    {@var LS_PagesStr - Varivel de internacionalizao para "Pginas" :/}
    LS_PagesStr: string;
    {@var LS_SelectionStr - Varivel de internacionalizao para "Seleo" :/}
    LS_SelectionStr: string;
    {@var LS_CopiesStr - Varivel de internacionalizao para "Cpias" :/}
    LS_CopiesStr: string;
    {@var LS_NumberOfCopiesStr - Varivel de internacionalizao para "Nmero de cpias" :/}
    LS_NumberOfCopiesStr: string;
    {@var LS_OkStr - Varivel de internacionalizao para "Ok" :/}
    LS_OkStr: string;
    {@var LS_DivideScreenStr - Varivel de internacionalizao para "Dividir a tela" :/}
    LS_DivideScreenStr: string;
    {@var LS_InvalidNameStr - Varivel de internacionalizao para "Nome invlido" :/}
    LS_InvalidNameStr: string;
    {@var LS_DuplicateNameStr - Varivel de internacionalizao para "Nome j utilizado" :/}
    LS_DuplicateNameStr: string;
    {@var LS_UseFilterStr - Varivel de internacionalizao para "Usar Filtro" :/}
    LS_UseFilterStr: string;
    {@var LS_WebPageStr - Varivel de internacionalizao para "Pgina da Web" :/}
    LS_WebPageStr: string;
    {@var LS_RichFormatStr - Varivel de internacionalizao para "Formato RichText" :/}
    LS_RichFormatStr: string;
    {@var LS_PDFFormatStr - Varivel de internacionalizao para "Documento PDF" :/}
    LS_PDFFormatStr: string;
    {@var LS_XLSFormatStr - Varivel de internacionalizao para "Planilha Excel" :/}
    LS_XLSFormatStr: string;
    {@var LS_AtStr - Varivel de internacionalizao para "em" :/}
    LS_AtStr: string;
    {@var LS_FormStr - Varivel de internacionalizao para "Formulrio" :/}
    LS_FormStr: string;
    {@var LS_DefaultStr - Varivel de internacionalizao para "Padro" :/}
    LS_DefaultStr: string;
    {@var LS_ZoomInStr - Varivel de internacionalizao para "Aumentar o zoom" :/}
    LS_ZoomInStr: string;
    {@var LS_ZoomOutStr - Varivel de internacionalizao para "Diminuir o zoom" :/}
    LS_ZoomOutStr: string;
    {@var LS_CopyStr - Varivel de internacionalizao para "Copiar" :/}
    LS_CopyStr: string;
    {@var LS_EditStr - Varivel de internacionalizao para "Editar" :/}
    LS_EditStr: string;
    {@var LS_FindCaptionStr - Varivel de internacionalizao para "Procurar" :/}
    LS_FindCaptionStr: string;
    {@var LS_TextToFindStr - Varivel de internacionalizao para "Te&xto" :/}
    LS_TextToFindStr: string;
    {@var LS_FindNextStr - &Varivel de internacionalizao para "Prxima" :/}
    LS_FindNextStr: string;
    {@var LS_WholeWordsStr - Varivel de internacionalizao para "Palavras &inteiras" :/}
    LS_WholeWordsStr: string;
    {@var LS_MatchCaseStr - Varivel de internacionalizao para "Diferenciar &maisculas de minsculas" :/}
    LS_MatchCaseStr: string;
    {@var LS_DirectionUpStr - Varivel de internacionalizao para "A&cima" :/}
    LS_DirectionUpStr: string;
    {@var LS_DirectionDownStr - Varivel de internacionalizao para "A&baixo" :/}
    LS_DirectionDownStr: string;
    {@var LS_DirectionCaptionStr - Varivel de internacionalizao para "Direo" :/}
    LS_DirectionCaptionStr: string;
    {@var LS_ColumnsStr - Varivel de internacionalizao para "Colunas". :/}
    LS_ColumnsStr: string;
    {@var LS_SetupStr - Varivel de internacionalizao para "Configurao". :/}
    LS_SetupStr: string;
    {@var LS_FontSizeError - Varivel de internacionalizao para "Erro no clculo das fontes". :/}
    LS_FontSizeError: string;
    {@var LS_OddPages - Varivel de internacionalizao para "mpares". :/}
    LS_OddPages: string;
    {@var LS_EvenPages - Varivel de internacionalizao para "Pares". :/}
    LS_EvenPages: string;
    {@var LS_OddPagesOnly - Varivel de internacionalizao para "mpares somente". :/}
    LS_OddPagesOnly: string;
    {@var LS_EvenPagesOnly - Varivel de internacionalizao para "Pares somente". :/}
    LS_EvenPagesOnly: string;
    {@var LS_AllOddAndEven - Varivel de internacionalizao para "Todas". :/}
    LS_AllOddAndEven: string;
    {@var LS_PrintDialogError - Varivel de internacionalizao para "Problemas com o dilogo da impressora". :/}
    LS_PrintDialogError: string;
    {@var LS_PageSelectionHint - Varivel de internacionalizao para "Separe com ponto-e-vrgula os nmeros ou intervalos de pginas a imprimir. Ex.: 1;3;5-12;4". :/}
    LS_PageSelectionHint: string;
    {@var LS_DefaultJobTitle - Varivel de internacionalizao para "Relatrio %s". :/}
    LS_DefaultJobTitle: string;
    {@var LS_ZoomHint - Varivel de internacionalizao para "Diminuir o zoom" :/}
    LS_ZoomHint: string;
    {@var Ls_Nome_Arquivo - Varivel de internacionalizao para "Aplicar". :/}
    Ls_Aplicar: String;
    {@var Ls_Nome_Arquivo - Varivel de internacionalizao para "Propriedades". :/}
    Ls_Propriedades: String;
    {@var Ls_Salvar_Como - Varivel de internacionalizao para "Salvar como". :/}
    Ls_Salvar_Como: String;
    {@var Ls_Nome_Arquivo - Varivel de internacionalizao para "Nome do Arquivo". :/}
    Ls_Nome_Arquivo: String;
    {@var Ls_File_corrupted - Varivel de internacionalizao para "Arquivo corrompido". :/}
    Ls_File_corrupted: String;
    {@var Ls_File_corrupted - Varivel de internacionalizao para "Verso de Arquivo invlido". :/}
    Ls_File_version: String;
    {@var Ls_Page_setings - Varivel de internacionalizao para "Configurao da Pgina". :/}
    Ls_Page_settings: String;
    {@var Ls_Page_margins - Varivel de internacionalizao para "Margem da Pgina". :/}
    Ls_Page_margins: String;
    {@var Ls_Page_margins_top - Varivel de internacionalizao para "Margem Superior". :/}
    Ls_Page_margins_top: String;
    {@var Ls_Page_margins_bottom - Varivel de internacionalizao para "Margem Inferior". :/}
    Ls_Page_margins_bottom: String;
    {@var Ls_Page_margins_rigth - Varivel de internacionalizao para "Margem direita". :/}
    Ls_Page_margins_rigth: String;
    {@var Ls_Page_left_bottom - Varivel de internacionalizao para "Margem equerda". :/}
    Ls_Page_margins_left: String;
    {@var Ls_Page_margins_paper - Varivel de internacionalizao para "Margem do Papel". :/}
    Ls_Page_margins_paper: String;
    {@var Ls_Page_paper - Varivel de internacionalizao para "Papel". :/}
    Ls_Page_paper: String;
    {@var Ls_Paper_Size - Varivel de internacionalizao para "Tamanho do Papel". :/}
    Ls_Paper_Size: String;
    {@var Ls_Paper_Width - Varivel de internacionalizao para "Largura do Papel". :/}
    Ls_Paper_Size_Width: String;
    {@var Ls_Paper_Size_Heigth - Varivel de internacionalizao para "Altura do Papel". :/}
    Ls_Paper_Size_Heigth: String;
    {@var Ls_Paper_Orientation - Varivel de internacionalizao para "Orientao do Papel". :/}
    Ls_Paper_Orientation: String;
    {@var Ls_Paper_Orientation_Landscape - Varivel de internacionalizao para "Orientao da pgina em retrato". :/}
    Ls_Paper_Orientation_Landscape: String;
    {@var Ls_Paper_Orientation_Portrait - Varivel de internacionalizao para "Orientao da pgina em paisagem". :/}
    Ls_Paper_Orientation_Portrait: String;

    LS_LastFooMsg: string;
  end;

var
  LocaleStrings: TRLLocaleStrings;
  ReportServiceMode: Boolean = False;

procedure DetectLocale;

{/@unit}


implementation

var
  KnownCommercialVersion: Integer = 0;
  KnownReleaseVersion: Integer = 0;
  KnownCommentVersion: string = '';

var
  EnglishStrings: TRLLocaleStrings = (
    LS_PrintingInProgressStr: 'Printing in progress...';
    LS_FilterInProgressStr: 'Saving report...';
    LS_PreparingReportStr: 'Preparing report...';
    LS_PrinterNotFoundStr: 'Printer not found';
    LS_NoPathToPrinterStr: 'Invalid printer path';
    LS_LoadDefaultConfigStr: 'Load default configuration';
    LS_PrinterDriverErrorStr: 'Printer driver error';
    LS_PageStr: 'Page';
    LS_PrepareErrorStr: 'Error while preparing report';
    LS_PageBreakStr: 'Continues...';
    LS_PageMendStr: 'Continuation';
    LS_ReportEndStr: 'End';
    LS_FileNotFoundStr: 'File not found';
    LS_FileNameStr: 'File Name';
    LS_AllFileTypesStr: 'All files';
    LS_LoadReportStr: 'Load report';
    LS_NotFoundStr: 'Not found';
    LS_WaitStr: 'Wait...';
    LS_FinishedStr: 'Finished';
    LS_CancelStr: 'Cancel';
    LS_CloseStr: 'Close';
    LS_SaveStr: 'Save';
    LS_SendStr: 'Send';
    LS_PrintStr: 'Print';
    LS_AboutTheStr: 'About';
    LS_PreviewStr: 'Preview';
    LS_OfStr: 'of';
    LS_ZoomStr: 'Zoom';
    LS_FirstPageStr: 'First page';
    LS_PriorPageStr: 'Prior page';
    LS_NextPageStr: 'Next page';
    LS_LastPageStr: 'Last page';
    LS_EntirePageStr: 'Entire page';
    LS_EntireWidthStr: 'Entire width';
    LS_MultiplePagesStr: 'Multiple pages';
    LS_ConfigPrinterStr: 'Configure printer';
    LS_SaveToFileStr: 'Save to file';
    LS_SendToStr: 'Send to';
    LS_PrinterStr: 'Printer';
    LS_NameStr: 'Name';
    LS_PrintToFileStr: 'Print to file';
    LS_PrintInBackgroundStr: 'Print in background';
    LS_OptionsStr: 'Options';
    LS_SaveInBackground: 'Save in background';
    LS_PageRangeStr: 'Page range';
    LS_CopyAsImageStr: 'Copy as image';
    LS_RangeFromStr: 'from';
    LS_RangeToStr: 'to';
    LS_AllStr: 'All';
    LS_PagesStr: 'Pages';
    LS_SelectionStr: 'Selection';
    LS_CopiesStr: 'Copies';
    LS_NumberOfCopiesStr: 'Number of copies';
    LS_OkStr: 'Ok';
    LS_DivideScreenStr: 'Divide the screen';
    LS_InvalidNameStr: 'Invalid name';
    LS_DuplicateNameStr: 'Name already in use';
    LS_UseFilterStr: 'Use filter';
    LS_WebPageStr: 'Web page';
    LS_RichFormatStr: 'RichText Format';
    LS_PDFFormatStr: 'PDF Document';
    LS_XLSFormatStr: 'Excel spreadsheet';
    LS_AtStr: 'at';
    LS_FormStr: 'Form';
    LS_DefaultStr: 'Default';
    LS_ZoomInStr: 'Increase zoom';
    LS_ZoomOutStr: 'Decrease zoom';
    LS_CopyStr: 'Copy';
    LS_EditStr: 'Edit';
    LS_FindCaptionStr: 'Find';
    LS_TextToFindStr: 'Te&xt';
    LS_FindNextStr: 'Find &Next';
    LS_WholeWordsStr: '&Whole words only';
    LS_MatchCaseStr: '&Match Case';
    LS_DirectionUpStr: '&Up';
    LS_DirectionDownStr: '&Down';
    LS_DirectionCaptionStr: 'Direction';
    LS_ColumnsStr: 'Columns';
    LS_SetupStr: 'Setup...';
    LS_FontSizeError: 'Font size error';
    LS_OddPages: 'Odd';
    LS_EvenPages: 'Even';
    LS_OddPagesOnly: 'Odd pages only';
    LS_EvenPagesOnly: 'Even pages only';
    LS_AllOddAndEven: 'All';
    LS_PrintDialogError: 'Problems with print dialog';
    LS_PageSelectionHint: 'Separate page numbers or page intervals with ";". i.e.: 1;3;5-12;4';
    LS_DefaultJobTitle: 'Report "%s"';
    LS_Propriedades: 'Settings';
  );

var
  PortugueseStrings: TRLLocaleStrings = (
    LS_PrintingInProgressStr: 'Imprimindo o relatrio...';
    LS_FilterInProgressStr: 'Salvando o relatrio...';
    LS_PreparingReportStr: 'Preparando o relatrio...';
    LS_PrinterNotFoundStr: 'Nenhuma impressora encontrada';
    LS_NoPathToPrinterStr: 'Caminho invlido para a impressora';
    LS_LoadDefaultConfigStr: 'Ser carregada a configurao padro';
    LS_PrinterDriverErrorStr: 'Erro no driver da impressora';
    LS_PageStr: 'Pgina';
    LS_PrepareErrorStr: 'Erro durante a preparao do relatrio';
    LS_PageBreakStr: 'Continua...';
    LS_PageMendStr: 'Continuao';
    LS_ReportEndStr: 'Fim';
    LS_FileNotFoundStr: 'Arquivo no encontrado';
    LS_FileNameStr: 'Nome do arquivo';
    LS_AllFileTypesStr: 'Todos os arquivos';
    LS_LoadReportStr: 'Carregar relatrio';
    LS_NotFoundStr: 'No encontrado';
    LS_WaitStr: 'Aguarde...';
    LS_FinishedStr: 'Concludo';
    LS_CancelStr: 'Cancelar';
    LS_CloseStr: 'Fechar';
    LS_SaveStr: 'Salvar';
    LS_SendStr: 'Enviar';
    LS_PrintStr: 'Imprimir';
    LS_AboutTheStr: 'Sobre o';
    LS_PreviewStr: 'Pr-visualizao';
    LS_OfStr: 'de';
    LS_ZoomStr: 'Zoom';
    LS_FirstPageStr: 'Primeira pgina';
    LS_PriorPageStr: 'Pgina anterior';
    LS_NextPageStr: 'Prxima pgina';
    LS_LastPageStr: 'ltima pgina';
    LS_EntirePageStr: 'Pgina inteira';
    LS_EntireWidthStr: 'Largura da pgina';
    LS_MultiplePagesStr: 'Vrias pginas'; 
    LS_ConfigPrinterStr: 'Configurar impressora';
    LS_SaveToFileStr: 'Salvar em disco';
    LS_SendToStr: 'Enviar para';
    LS_PrinterStr: 'Impressora';
    LS_NameStr: 'Nome';
    LS_PrintToFileStr: 'Imprimir em arquivo';
    LS_PrintInBackgroundStr: 'Imprimir em segundo plano';
    LS_OptionsStr: 'Opes';
    LS_SaveInBackground: 'Salvar em segundo plano';
    LS_PageRangeStr: 'Intervalo de pginas';
    LS_CopyAsImageStr: 'Copiar como imagem';
    LS_RangeFromStr: 'de';
    LS_RangeToStr: 'at';
    LS_AllStr: 'Tudo';
    LS_PagesStr: 'Pginas';
    LS_SelectionStr: 'Seleo';
    LS_CopiesStr: 'Cpias';
    LS_NumberOfCopiesStr: 'Nmero de cpias';
    LS_OkStr: 'Ok';
    LS_DivideScreenStr: 'Dividir a tela';
    LS_InvalidNameStr: 'Nome invlido';
    LS_DuplicateNameStr: 'Nome j utilizado';
    LS_UseFilterStr: 'Usar Filtro';
    LS_WebPageStr: 'Pgina da Web';
    LS_RichFormatStr: 'Formato RichText';
    LS_PDFFormatStr: 'Documento PDF';
    LS_XLSFormatStr: 'Planilha Excel';
    LS_AtStr: 'em';
    LS_FormStr: 'Formulrio';
    LS_DefaultStr: 'Padro';
    LS_ZoomInStr: 'Aumentar o zoom';
    LS_ZoomOutStr: 'Diminuir o zoom';
    LS_CopyStr: 'Copiar';
    LS_EditStr: 'Editar';
    LS_FindCaptionStr: 'Procurar';
    LS_TextToFindStr: 'Te&xto';
    LS_FindNextStr: '&Prxima';
    LS_WholeWordsStr: 'Palavras &inteiras';
    LS_MatchCaseStr: 'Diferenciar &maisculas de minsculas';
    LS_DirectionUpStr: 'A&cima';
    LS_DirectionDownStr: 'A&baixo';
    LS_DirectionCaptionStr: 'Direo';
    LS_ColumnsStr: 'Colunas';
    LS_SetupStr: 'Configurao';
    LS_FontSizeError: 'Erro no clculo das fontes';
    LS_OddPages: 'mpares';
    LS_EvenPages: 'Pares';
    LS_OddPagesOnly: 'Somente mpares';
    LS_EvenPagesOnly: 'Somente Pares';
    LS_AllOddAndEven: 'Todas';
    LS_PrintDialogError: 'Problemas com o dilogo da impressora';
    LS_PageSelectionHint: 'Separe com ponto-e-vrgula os nmeros ou intervalos de pginas a imprimir. Ex.: 1;3;5-12;4';
    LS_DefaultJobTitle: 'Relatrio "%s"';
    LS_ZoomHint: 'Voc tambm pode aumentar ou reduzir o zoom do relatrio' + #13 + 'precionando "Ctrl" e usando a rolagem do mouse.';
    Ls_Aplicar: 'Aplicar';
    Ls_Propriedades: 'Propriedades';
  );

var
  FrenchStrings: TRLLocaleStrings = (
    LS_PrintingInProgressStr: 'Impression du rapport...';
    LS_FilterInProgressStr: 'Sauver le rapport...';
    LS_PreparingReportStr: 'Prparation du rapport...';
    LS_PrinterNotFoundStr: 'Imprimante non trouve';
    LS_NoPathToPrinterStr: 'Invalid printer path';
    LS_LoadDefaultConfigStr: 'Chargement de la configuration standard';
    LS_PrinterDriverErrorStr: 'Erreur dans le driver d''impression';
    LS_PageStr: 'Page';
    LS_PrepareErrorStr: 'Erreur durant la prpartaion du rapport';
    LS_PageBreakStr: 'Saut de page...';
    LS_PageMendStr: 'A suivre';
    LS_ReportEndStr: 'Fin';
    LS_FileNotFoundStr: 'Fichier non trouv';
    LS_FileNameStr: 'Nom de Fichier';
    LS_AllFileTypesStr: 'Tous les fichiers';
    LS_LoadReportStr: 'Ouvrir rapport';
    LS_NotFoundStr: 'Non trouv';
    LS_WaitStr: 'Patientez...';
    LS_FinishedStr: 'Fini';
    LS_CancelStr: 'Annul';
    LS_CloseStr: 'Ferm';
    LS_SaveStr: 'Sauver';
    LS_SendStr: 'Envoyez';
    LS_PrintStr: 'Imprimer';
    LS_AboutTheStr: 'A propos de';
    LS_PreviewStr: 'Aperu avant impression';
    LS_OfStr: 'de';
    LS_ZoomStr: 'Zoom';
    LS_FirstPageStr: 'Premire page';
    LS_PriorPageStr: 'Page prcdente';
    LS_NextPageStr: 'Page suivante';
    LS_LastPageStr: 'Dernire page';
    LS_EntirePageStr: 'Page entire';
    LS_EntireWidthStr: 'Pleine largeur';
    LS_MultiplePagesStr: 'Plusieurs pages';
    LS_ConfigPrinterStr: 'Configuration de l''imprimante';
    LS_SaveToFileStr: 'Enregistrer sous';
    LS_SendToStr: 'Envoyez ';
    LS_PrinterStr: 'Imprimante';
    LS_NameStr: 'Nom';
    LS_PrintToFileStr: 'Imprimer dans un fichier';
    LS_PrintInBackgroundStr: 'Imprimer dans background';
    LS_OptionsStr: 'Opciones';
    LS_SaveInBackground: 'Enregistrer dans background';
    LS_PageRangeStr: 'Intervalle de pages';
    LS_CopyAsImageStr: 'Copy as image';
    LS_RangeFromStr: 'de';
    LS_RangeToStr: '';
    LS_AllStr: 'Tout';
    LS_PagesStr: 'Pages';
    LS_SelectionStr: 'Slection';
    LS_CopiesStr: 'Copies';
    LS_NumberOfCopiesStr: 'Nombre de copies';
    LS_OkStr: 'Ok';
    LS_DivideScreenStr: 'Dividir a tela';
    LS_InvalidNameStr: 'Nom inadmissible';
    LS_DuplicateNameStr: 'Nom reproduit';
    LS_UseFilterStr: 'Use filter';
    LS_WebPageStr: 'Page de Web';
    LS_RichFormatStr: 'Formato RichText';
    LS_PDFFormatStr: 'Documento PDF';
    LS_XLSFormatStr: 'Excel tableur';
    LS_AtStr: '';
    LS_FormStr: 'Formulaire';
    LS_DefaultStr: 'Dfaut';
    LS_ZoomInStr: 'Grandir zoom';
    LS_ZoomOutStr: 'Rduire zoom';
    LS_CopyStr: 'Copier';
    LS_EditStr: 'Edit';
    LS_FindCaptionStr: 'Trouvaille';
    LS_TextToFindStr: 'Te&xte';
    LS_FindNextStr: 'A&prs';
    LS_WholeWordsStr: 'Mots &entiers seulement';
    LS_MatchCaseStr: 'Cas d''allu&mette';
    LS_DirectionUpStr: 'Le &Haut';
    LS_DirectionDownStr: 'Le &bas';
    LS_DirectionCaptionStr: 'Direction';
    LS_ColumnsStr: 'Cols';
    LS_SetupStr: 'Setup...';
    LS_FontSizeError: 'Font size error';
    LS_OddPages: 'Odd';
    LS_EvenPages: 'Even';
    LS_OddPagesOnly: 'Odd pages only';
    LS_EvenPagesOnly: 'Even pages only';
    LS_AllOddAndEven: 'All';
    LS_PrintDialogError: 'Problems calling the printer dialog';
    LS_PageSelectionHint: 'Separate page numbers or page intervals with ";". i.e.: 1;3;5-12;4';
    LS_DefaultJobTitle: 'Rapport "%s"';
    Ls_Aplicar: 'Bewerben Sie sich';
  );

var
  SpanishStrings: TRLLocaleStrings = (
    LS_PrintingInProgressStr: 'Impresin en marcha...';
    LS_FilterInProgressStr: 'Guardando el informe...';
    LS_PreparingReportStr: 'Preparacin del informe...';
    LS_PrinterNotFoundStr: 'Impresora no encontrada';
    LS_NoPathToPrinterStr: 'Caminho invlido para a impressora';
    LS_LoadDefaultConfigStr: 'Cargar la configuracin estndar';
    LS_PrinterDriverErrorStr: 'Error en driver de la impresora';
    LS_PageStr: 'Pgina';
    LS_PrepareErrorStr: 'Un error ocurri mientras se preparaba el informe';
    LS_PageBreakStr: 'Contina...';
    LS_PageMendStr: 'Continuacin';
    LS_ReportEndStr: 'Extremo';
    LS_FileNotFoundStr: 'Archivo no encontrado';
    LS_FileNameStr: 'Nombre del Archivo';
    LS_AllFileTypesStr: 'Todos los archivos';
    LS_LoadReportStr: 'Cargar el informe';
    LS_NotFoundStr: 'No encontrado';
    LS_WaitStr: 'Espera...';
    LS_FinishedStr: 'Finalizado';
    LS_CancelStr: 'Cancelar';
    LS_CloseStr: 'Cerrar';
    LS_SaveStr: 'Guardar';
    LS_SendStr: 'Enviar';
    LS_PrintStr: 'Imprimir';
    LS_AboutTheStr: 'Sobre';
    LS_PreviewStr: 'Ver';
    LS_OfStr: 'de';
    LS_ZoomStr: 'Zoom';
    LS_FirstPageStr: 'Primera pgina';
    LS_PriorPageStr: 'Pgina anterior';
    LS_NextPageStr: 'Pgina siguiente';
    LS_LastPageStr: 'ltima pgina';
    LS_EntirePageStr: 'Pgina entera';
    LS_EntireWidthStr: 'Ancho completo';
    LS_MultiplePagesStr: 'Varias pginas';
    LS_ConfigPrinterStr: 'Configurar la impresora';
    LS_SaveToFileStr: 'Guardar en un archivo';
    LS_SendToStr: 'Envar a';
    LS_PrinterStr: 'Impresora';
    LS_NameStr: 'Nombre';
    LS_PrintToFileStr: 'Imprimir a un archivo';
    LS_PrintInBackgroundStr: 'Imprimir en background';
    LS_OptionsStr: 'Opziones';
    LS_SaveInBackground: 'Guardar en background';
    LS_PageRangeStr: 'Intervalo de pginas';
    LS_CopyAsImageStr: 'Copy as image';
    LS_RangeFromStr: 'de';
    LS_RangeToStr: 'a';
    LS_AllStr: 'Todas';
    LS_PagesStr: 'Pginas';
    LS_SelectionStr: 'Seleccin';
    LS_CopiesStr: 'Copias';
    LS_NumberOfCopiesStr: 'Nmero de copias';
    LS_OkStr: 'Ok';
    LS_DivideScreenStr: 'Dividir la pantalla';
    LS_InvalidNameStr: 'Nombre invlido';
    LS_DuplicateNameStr: 'Nombre ya en uso';
    LS_UseFilterStr: 'Usar Filtro';
    LS_WebPageStr: 'Pgina Web';
    LS_RichFormatStr: 'Formato RichText';
    LS_PDFFormatStr: 'Documento PDF';
    LS_XLSFormatStr: 'Planilha Excel';
    LS_AtStr: 'en';
    LS_FormStr: 'Formulario';
    LS_DefaultStr: 'Estndar';
    LS_ZoomInStr: 'Aumentar zoom';
    LS_ZoomOutStr: 'Disminuir zoom';
    LS_CopyStr: 'Copiar';
    LS_EditStr: 'Editar';
    LS_FindCaptionStr: 'Buscar';
    LS_TextToFindStr: 'Te&xto';
    LS_FindNextStr: '&Siguiente';
    LS_WholeWordsStr: 'Palabras &completas slamente';
    LS_MatchCaseStr: 'Diferenciar &maysculas y minsculas';
    LS_DirectionUpStr: 'En&cima';
    LS_DirectionDownStr: '&Abajo';
    LS_DirectionCaptionStr: 'Direccin';
    LS_ColumnsStr: 'Cols';
    LS_SetupStr: 'Setup...';
    LS_FontSizeError: 'Erro no clculo das fontes';
    LS_OddPages: 'mpares';
    LS_EvenPages: 'Pares';
    LS_OddPagesOnly: 'Somente mpares';
    LS_EvenPagesOnly: 'Somente Pares';
    LS_AllOddAndEven: 'Todas';
    LS_PrintDialogError: 'Problemas com o dilogo da impressora';
    LS_PageSelectionHint: 'Separe com ponto-e-vrgula os nmeros ou intervalos de pginas a imprimir. Ex.: 1;3;5-12;4';
    LS_DefaultJobTitle: 'Impresin "%s"';
  );

var
  ItalianStrings: TRLLocaleStrings = (
    LS_PrintingInProgressStr: 'Impression du rapport...';
    LS_FilterInProgressStr: 'Sauver le rapport...';
    LS_PreparingReportStr: 'Prparation du rapport...';
    LS_PrinterNotFoundStr: 'Imprimante non trouve';
    LS_NoPathToPrinterStr: 'Invalid printer path';
    LS_LoadDefaultConfigStr: 'Chargement de la configuration standard';
    LS_PrinterDriverErrorStr: 'Erreur dans le driver d''impression';
    LS_PageStr: 'Page';
    LS_PrepareErrorStr: 'Erreur durant la prpartaion du rapport';
    LS_PageBreakStr: 'Continua...';
    LS_PageMendStr: 'Continuazione';
    LS_ReportEndStr: 'Fine';
    LS_FileNotFoundStr: 'Archivio non fond';
    LS_FileNameStr: 'Nome di file';
    LS_AllFileTypesStr: 'Tutti archiviano';
    LS_LoadReportStr: 'Rapporto di carico';
    LS_NotFoundStr: 'Non fondato';
    LS_WaitStr: 'Attesa...';
    LS_FinishedStr: 'Finito';
    LS_CancelStr: 'Annulli';
    LS_CloseStr: 'Vicino';
    LS_SaveStr: 'Salvataggio';
    LS_SendStr: 'Spinta dellonda';
    LS_PrintStr: 'Stampa';
    LS_AboutTheStr: 'Circa';
    LS_PreviewStr: 'Anteprima';
    LS_OfStr: 'di';
    LS_ZoomStr: 'Zoom';
    LS_FirstPageStr: 'Prima la pagina';
    LS_PriorPageStr: 'Antecedente la pagina';
    LS_NextPageStr: 'Prossimo pagina';
    LS_LastPageStr: 'Ultima pagina';
    LS_EntirePageStr: 'Pagina intera';
    LS_EntireWidthStr: 'Ampiezza intera';
    LS_MultiplePagesStr: 'Pagine multiple';
    LS_ConfigPrinterStr: 'Configuri stampante';
    LS_SaveToFileStr: 'Salvi archiviare';
    LS_SendToStr: 'Spedisca a';
    LS_PrinterStr: 'Stampante';
    LS_NameStr: 'Nome';
    LS_PrintToFileStr: 'Stampi archiviare';
    LS_PrintInBackgroundStr: 'Stampi in sfondo';
    LS_OptionsStr: 'Opciones';
    LS_SaveInBackground: 'Salvi in sfondo';
    LS_PageRangeStr: 'Serie di pagina';
    LS_CopyAsImageStr: 'Copy as image';
    LS_RangeFromStr: 'da';
    LS_RangeToStr: 'a';
    LS_AllStr: 'Tutti';
    LS_PagesStr: 'Pagine';
    LS_SelectionStr: 'Selezione';
    LS_CopiesStr: 'Copie';
    LS_NumberOfCopiesStr: 'Numero di copie';
    LS_OkStr: 'Ok';
    LS_DivideScreenStr: 'Divida lo schermo';
    LS_InvalidNameStr: 'Nome nullo';
    LS_DuplicateNameStr: 'Gi chiami in uso';
    LS_UseFilterStr: 'Filtro di uso';
    LS_WebPageStr: 'Pagina di Web';
    LS_RichFormatStr: 'RichText Format';
    LS_PDFFormatStr: 'PDF Document';
    LS_XLSFormatStr: 'Eccella foglio di calcolo elettronico';
    LS_AtStr: 'a';
    LS_FormStr: 'Forma';
    LS_DefaultStr: 'Contumacia';
    LS_ZoomInStr: 'Zoom di aumento';
    LS_ZoomOutStr: 'Zoom di calo';
    LS_CopyStr: 'Copia';
    LS_EditStr: 'Compili';
    LS_FindCaptionStr: 'Trouvaille';
    LS_TextToFindStr: 'Testo';
    LS_FindNextStr: 'Trovi Prossimo';
    LS_WholeWordsStr: 'Parole intere solamente';
    LS_MatchCaseStr: 'Accoppi Caso';
    LS_DirectionUpStr: 'Su';
    LS_DirectionDownStr: 'In gi';
    LS_DirectionCaptionStr: 'Direzione';
    LS_ColumnsStr: 'Colonnas';
    LS_SetupStr: 'Setup...';
    LS_FontSizeError: 'Font size error';
    LS_OddPages: 'Odd';
    LS_EvenPages: 'Even';
    LS_OddPagesOnly: 'Odd pages only';
    LS_EvenPagesOnly: 'Even pages only';
    LS_AllOddAndEven: 'All';
    LS_PrintDialogError: 'Problems calling the printer dialog';
    LS_PageSelectionHint: 'Separate page numbers or page intervals with ";". i.e.: 1;3;5-12;4';
    LS_DefaultJobTitle: 'Rapporto "%s"';
  );

var
  SwedishStrings: TRLLocaleStrings = (
    LS_PrintingInProgressStr: 'Das Drucken im Gange...';
    LS_FilterInProgressStr: 'Das Sparen von Bericht  ...';
    LS_PreparingReportStr: 'Das Vorbereiten von Berich...';
    LS_PrinterNotFoundStr: 'Drucker fand nicht';
    LS_NoPathToPrinterStr: 'Ungltiger Druckerpfad';
    LS_LoadDefaultConfigStr: 'Laden Sie Standardkonfiguration';
    LS_PrinterDriverErrorStr: 'Druckerfahrer Fehler';
    LS_PageStr: 'Seite';
    LS_PrepareErrorStr: 'Fehler, whrend das Vorbereiten von Bericht';
    LS_PageBreakStr: 'Setzt fort...';
    LS_PageMendStr: 'Fortsetzung';
    LS_ReportEndStr: 'Ende';
    LS_FileNotFoundStr: 'File fand nicht';
    LS_FileNameStr: 'Akte Name';
    LS_AllFileTypesStr: 'Alles legt ab';
    LS_LoadReportStr: 'Lastbericht';
    LS_NotFoundStr: 'Finden Sie nicht';
    LS_WaitStr: 'Wartezeit...';
    LS_FinishedStr: 'Beendet';
    LS_CancelStr: 'Sagen Sie ab';
    LS_CloseStr: 'Ende';
    LS_SaveStr: 'Ballabwehr';
    LS_SendStr: 'Schicken Sie';
    LS_PrintStr: 'Druck';
    LS_AboutTheStr: 'ber';
    LS_PreviewStr: 'Vorschau';
    LS_OfStr: 'von';
    LS_ZoomStr: 'Gummilinse';
    LS_FirstPageStr: 'Erste Seite';
    LS_PriorPageStr: 'Vorausgehende Seite';
    LS_NextPageStr: 'Danach Seite';
    LS_LastPageStr: 'Letzte Seite';
    LS_EntirePageStr: 'Ganze Seite';
    LS_EntireWidthStr: 'Ganze Weite';
    LS_MultiplePagesStr: 'Mehrfache Seiten';
    LS_ConfigPrinterStr: 'Konfigurieren Sie Drucker';
    LS_SaveToFileStr: 'Ballabwehr, um abzulegen';
    LS_SendToStr: 'Schicken Sie dazu';
    LS_PrinterStr: 'Drucker';
    LS_NameStr: 'Name';
    LS_PrintToFileStr: 'Drucker, um abzulegen';
    LS_PrintInBackgroundStr: 'Druck in Hintergrund ';
    LS_OptionsStr: 'Mglichkeiten';
    LS_SaveInBackground: 'Ballabwehr in Hintergrund';
    LS_PageRangeStr: 'Rufen Sie Auswahl aus';
    LS_CopyAsImageStr: 'Copy as image';
    LS_RangeFromStr: 'von';
    LS_RangeToStr: 'zu';
    LS_AllStr: 'Alles';
    LS_PagesStr: 'Seiten';
    LS_SelectionStr: 'Auswahl';
    LS_CopiesStr: 'Kopien';
    LS_NumberOfCopiesStr: 'Anzahl von Kopien';
    LS_OkStr: 'Ok';
    LS_DivideScreenStr: 'Teilen Sie den Bildschirm';
    LS_InvalidNameStr: 'Ungltiger Name';
    LS_DuplicateNameStr: 'Nennen Sie schon im Gebrauch';
    LS_UseFilterStr: 'Verwendungsfilter';
    LS_WebPageStr: 'Webseite';
    LS_RichFormatStr: 'RichText Format';
    LS_PDFFormatStr: 'PDF Document';
    LS_XLSFormatStr: 'Zeichnen Sie Tabelle aus';
    LS_AtStr: 'bei';
    LS_FormStr: 'Form';
    LS_DefaultStr: 'Versumnis';
    LS_ZoomInStr: 'Zunahmegummilinse';
    LS_ZoomOutStr: 'Abnahmengummilinse';
    LS_CopyStr: 'Kopie';
    LS_EditStr: 'Bearbeiten Sie';
    LS_FindCaptionStr: 'Fund';
    LS_TextToFindStr: 'Te&xt';
    LS_FindNextStr: 'Finden Sie danach';
    LS_WholeWordsStr: '&Ganze Wrter nur';
    LS_MatchCaseStr: '&Passen Sie Fall zusammen';
    LS_DirectionUpStr: '&Auf';
    LS_DirectionDownStr: '&Entlang';
    LS_DirectionCaptionStr: 'Richtung';
    LS_ColumnsStr: 'Sule';
    LS_SetupStr: 'Setup...';
    LS_FontSizeError: 'Font size error';
    LS_OddPages: 'Odd';
    LS_EvenPages: 'Even';
    LS_OddPagesOnly: 'Odd pages only';
    LS_EvenPagesOnly: 'Even pages only';
    LS_AllOddAndEven: 'All';
    LS_PrintDialogError: 'Problems calling the printer dialog';
    LS_PageSelectionHint: 'Separate page numbers or page intervals with ";". i.e.: 1;3;5-12;4';
    LS_DefaultJobTitle: 'Das Drucken "%s"';
  );

procedure DetectLocale;
{$IfNDef MSWINDOWS}
var
  dlct: string;
{$EndIf}
begin
{$IfNDef MSWINDOWS}
  dlct := AnsiUpperCase(Copy(GetEnvironmentVariable('LANG'), 1, 2));
  if dlct = 'EN' then
    LocaleStrings := EnglishStrings
  else if dlct = 'PT' then
    LocaleStrings := PortugueseStrings
  else if dlct = 'ES' then
    LocaleStrings := SpanishStrings
  else if dlct = 'FR' then
    LocaleStrings := FrenchStrings
  else if dlct = 'IT' then
    LocaleStrings := ItalianStrings
  else if dlct = 'SW' then
    LocaleStrings := SwedishStrings
  else
    LocaleStrings := EnglishStrings;
{$Else}
  case SysLocale.PriLangID of
    $09 {LANG_ENGLISH}: LocaleStrings := EnglishStrings;
    $16 {LANG_PORTUGUESE}: LocaleStrings := PortugueseStrings;
    $0a {LANG_SPANISH}: LocaleStrings := SpanishStrings;
    $0c {LANG_FRENCH}: LocaleStrings := FrenchStrings;
    $10 {LANG_ITALIAN}: LocaleStrings := ItalianStrings;
    $1d {LANG_SWEDISH}: LocaleStrings := SwedishStrings;
  else
    LocaleStrings := EnglishStrings;
  end;
{$EndIf}
end;

initialization
  DetectLocale;

end.

