unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  EditBtn, Buttons, Menus,
  {$IFDEF MSWINDOWS}
  Registry, ShlObj,
  {$ENDIF}
  PPDK_RegFileType;

type

  { TfrmMain }
  TfrmMain = class(TForm)
    btnSet: TButton;
    btnCancel: TButton;
    btnUnSet: TButton;
    chkINC: TCheckBox;
    chkLazarus32: TCheckBox;
    chkLazarus64: TCheckBox;
    chkLFM: TCheckBox;
    chkLPI: TCheckBox;
    chkLPK: TCheckBox;
    chkLPR: TCheckBox;
    btnBrowse: TSpeedButton;
    chkPAS: TCheckBox;
    chkPP: TCheckBox;
    grpAssoc: TGroupBox;
    grpArch: TGroupBox;
    pmnuDefOpenSET: TMenuItem;
    pmnuAssocSetMISC: TMenuItem;
    pmnuAssocSetSRC: TMenuItem;
    pmnuAssocSetPROJ: TMenuItem;
    pmnuAssocSetALL: TMenuItem;
    pmnuAssocSet: TPopupMenu;
    pmnuDefOpen: TPopupMenu;
    SelDirDlg: TSelectDirectoryDialog;
    txtLazarusPath: TEdit;
    grpLazarusPath: TGroupBox;
    procedure btnBrowseClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnSetClick(Sender: TObject);
    procedure btnUnSetClick(Sender: TObject);
    procedure chkLazarus32MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure chkLazarus64MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure grpAssocDblClick(Sender: TObject);
    procedure pmnuAssocSetALLClick(Sender: TObject);
    procedure pmnuAssocSetMISCClick(Sender: TObject);
    procedure pmnuAssocSetSRCClick(Sender: TObject);
    procedure pmnuAssocSetPROJClick(Sender: TObject);
    procedure pmnuDefOpenSETClick(Sender: TObject);
  private
    procedure CheckRegistry;
    procedure CheckBasePath;
  public
    { public declarations }
  end; 

var
  cLazBasePath :String;
  frmMain      :TfrmMain;
  Reg          :TRegistry;

implementation

{$R *.lfm}

{ TfrmMain }

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  FreeAndNil(Reg);
end;

procedure TfrmMain.btnSetClick(Sender: TObject);
var
  cLaz32FullPath,
  cLaz64FullPath: String;
  bIsDefault32,
  bIsDefault64:   Boolean;
begin
  if(chkLazarus32.Checked)then
  begin
    cLaz32FullPath := cLazBasePath + '\bin32\lazarus.exe "%1"';
    bIsDefault32 := chkLazarus32.Tag = 1;
    if(chkLPI.Checked)then
    begin
      SetFileExt(Reg, '.lpi', 'LazarusProject', 'Lazarus Project Information', 'Open with Lazarus', 'open',
      cLaz32FullPath, cLazBasePath + '\images\LazarusProject.ico', bIsDefault32);
    end;
    if(chkLPR.Checked)then
    begin
      SetFileExt(Reg, '.lpr', 'LazarusProjectSource', 'Lazarus Project Main Source', 'Open with Lazarus', 'open',
      cLaz32FullPath, cLazBasePath + '\images\lprfile.ico', bIsDefault32);
    end;
    if(chkLPK.Checked)then
    begin
      SetFileExt(Reg, '.lpk', 'LazarusPackage', 'Lazarus Package File', 'Open with Lazarus', 'open',
      cLaz32FullPath, cLazBasePath + '\images\lazaruspackage.ico', bIsDefault32);
    end;
    if(chkLFM.Checked)then
    begin
    	SetFileExt(Reg, '.lfm', 'LazarusForm', 'Lazarus Form File', 'Open with Lazarus', 'open',
      cLaz32FullPath, cLazBasePath + '\images\LazarusForm.ico', bIsDefault32);
    end;
    if(chkPAS.Checked)then
    begin
    	SetFileExt(Reg, '.pas', 'LazarusUnit', 'Object Pascal Unit', 'Open with Lazarus', 'open',
      cLaz32FullPath, cLazBasePath + '\images\LazarusSource.ico', bIsDefault32);
    end;
    if(chkPP.Checked)then
    begin
  		SetFileExt(Reg, '.pp', 'LazarusFPCUnit', 'Object Pascal Unit', 'Open with Lazarus', 'open',
      cLaz32FullPath, cLazBasePath + '\images\LazarusSource.ico', bIsDefault32);
    end;
    if(chkINC.Checked)then
    begin
  		SetFileExt(Reg, '.inc', 'LazarusInclude', 'Object Pascal Include File', 'Open with Lazarus', 'open',
      cLaz32FullPath, cLazBasePath + '\images\includefile.ico', bIsDefault32);
    end;
  end;
  //
  if(chkLazarus64.Checked)then
  begin
    cLaz64FullPath := cLazBasePath + '\bin64\lazarus.exe "%1"';
    bIsDefault64 := chkLazarus64.Tag = 1;
    if(chkLPI.Checked)then
    begin
      SetFileExt(Reg, '.lpi', 'LazarusProject', 'Lazarus Project Information', 'Open with Lazarus (x64)', 'open64',
      cLaz64FullPath, cLazBasePath + '\images\LazarusProject.ico', bIsDefault64);
    end;
    if(chkLPR.Checked)then
    begin
      SetFileExt(Reg, '.lpr', 'LazarusProjectSource', 'Lazarus Project Main Source', 'Open with Lazarus (x64)', 'open64',
      cLaz64FullPath, cLazBasePath + '\images\lprfile.ico', bIsDefault64);
    end;
    if(chkLPK.Checked)then
    begin
      SetFileExt(Reg, '.lpk', 'LazarusPackage', 'Lazarus Package File', 'Open with Lazarus (x64)', 'open64',
      cLaz64FullPath, cLazBasePath + '\images\lazaruspackage.ico', bIsDefault64);
    end;
    if(chkLFM.Checked)then
    begin
    	SetFileExt(Reg, '.lfm', 'LazarusForm', 'Lazarus Form File', 'Open with Lazarus (x64)', 'open64',
      cLaz64FullPath, cLazBasePath + '\images\LazarusForm.ico', bIsDefault64);
    end;
    if(chkPAS.Checked)then
    begin
    	SetFileExt(Reg, '.pas', 'LazarusUnit', 'Object Pascal Unit', 'Open with Lazarus (x64)', 'open64',
      cLaz64FullPath, cLazBasePath + '\images\LazarusSource.ico', bIsDefault64);
    end;
    if(chkPP.Checked)then
    begin
  		SetFileExt(Reg, '.pp', 'LazarusFPCUnit', 'Object Pascal Unit', 'Open with Lazarus (x64)', 'open64',
      cLaz64FullPath, cLazBasePath + '\images\LazarusSource.ico', bIsDefault64);
    end;
    if(chkINC.Checked)then
    begin
  		SetFileExt(Reg, '.inc', 'LazarusInclude', 'Object Pascal Include File', 'Open with Lazarus (x64)', 'open64',
      cLaz64FullPath, cLazBasePath + '\images\includefile.ico', bIsDefault64);
    end;
  end;
  CheckRegistry;
  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
end;

procedure TfrmMain.btnUnSetClick(Sender: TObject);
begin
  if(chkLPI.Checked)then
  begin
    UnSetFileExt(Reg, '.lpi');
  end;
  if(chkLPR.Checked)then
  begin
    UnSetFileExt(Reg, '.lpr');
  end;
  if(chkLPK.Checked)then
  begin
    UnSetFileExt(Reg, '.lpk');
  end;
  if(chkLFM.Checked)then
  begin
    UnSetFileExt(Reg, '.lfm');
  end;
  if(chkPAS.Checked)then
  begin
    UnSetFileExt(Reg, '.pas');
  end;
  if(chkPP.Checked)then
  begin
    UnSetFileExt(Reg, '.pp');
  end;
  if(chkINC.Checked)then
  begin
    UnSetFileExt(Reg, '.inc');
  end;
  CheckRegistry;
  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
end;

procedure TfrmMain.chkLazarus32MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if(chkLazarus32.Tag = 0)then
  begin
    chkLazarus32.PopupMenu := pmnuDefOpen;
  end
  else
  begin
    chkLazarus32.PopupMenu := nil;
  end;
end;

procedure TfrmMain.chkLazarus64MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if(chkLazarus64.Tag = 0)then
  begin
    chkLazarus64.PopupMenu := pmnuDefOpen;
  end
  else
  begin
    chkLazarus64.PopupMenu := nil;
  end;
end;

procedure TfrmMain.btnCancelClick(Sender: TObject);
begin
	Self.Close;
  Application.Terminate;
end;

procedure TfrmMain.btnBrowseClick(Sender: TObject);
begin
  SelDirDlg.InitialDir := txtLazarusPath.Text;
  if(SelDirDlg.Execute)then
  begin
    txtLazarusPath.Text := SelDirDlg.FileName;
    CheckBasePath;
  end;
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
  Reg := TRegistry.Create();
  CheckRegistry;
  CheckBasePath;
end;

procedure TfrmMain.grpAssocDblClick(Sender: TObject);
begin
  chkLPI.Checked := true;
  chkLPR.Checked := true;
  chkLPK.Checked := true;
  chkLFM.Checked := true;
  chkPAS.Checked := true;
  chkPP.Checked  := true;
  chkINC.Checked := false;
end;

procedure TfrmMain.pmnuAssocSetALLClick(Sender: TObject);
begin
  chkLPI.Checked := true;
  chkLPR.Checked := true;
  chkLPK.Checked := true;
  chkLFM.Checked := true;
  chkPAS.Checked := true;
  chkPP.Checked  := true;
  chkINC.Checked := true;
end;

procedure TfrmMain.pmnuAssocSetMISCClick(Sender: TObject);
begin
  chkLPI.Checked := false;
  chkLPR.Checked := false;
  chkLPK.Checked := false;
  chkLFM.Checked := true;
  chkPAS.Checked := false;
  chkPP.Checked  := false;
  chkINC.Checked := true;
end;

procedure TfrmMain.pmnuAssocSetSRCClick(Sender: TObject);
begin
  chkLPI.Checked := false;
  chkLPR.Checked := false;
  chkLPK.Checked := false;
  chkLFM.Checked := false;
  chkPAS.Checked := true;
  chkPP.Checked  := true;
  chkINC.Checked := false;
end;

procedure TfrmMain.pmnuAssocSetPROJClick(Sender: TObject);
begin
  chkLPI.Checked := true;
  chkLPR.Checked := true;
  chkLPK.Checked := true;
  chkLFM.Checked := false;
  chkPAS.Checked := false;
  chkPP.Checked  := false;
  chkINC.Checked := false;
end;

procedure TfrmMain.pmnuDefOpenSETClick(Sender: TObject);
begin
  if(pmnuDefOpen.PopupComponent = chkLazarus64)then
  begin
    chkLazarus64.Tag := 1;
    chkLazarus64.Font.Style := chkLazarus64.Font.Style + [fsBold];
    chkLazarus32.Tag := 0;
    chkLazarus32.Font.Style := chkLazarus32.Font.Style - [fsBold];
  end
  else
  if(pmnuDefOpen.PopupComponent = chkLazarus32)then
  begin
    chkLazarus32.Tag := 1;
    chkLazarus32.Font.Style := chkLazarus32.Font.Style + [fsBold];
    chkLazarus64.Tag := 0;
    chkLazarus64.Font.Style := chkLazarus64.Font.Style - [fsBold];
  end;
end;

procedure TfrmMain.CheckRegistry;
begin
  chkLPI.Checked := GetFileExt(Reg, '.lpi');//can use DOT before extention
  chkLPR.Checked := GetFileExt(Reg, '.lpr');//..
  chkLPK.Checked := GetFileExt(Reg, '.lpk');//..
  chkLFM.Checked := GetFileExt(Reg, '.lfm');//..
  chkPAS.Checked := GetFileExt(Reg, 'pas'); //or NOT
  chkPP.Checked  := GetFileExt(Reg, 'pp');  //..
  chkINC.Checked := GetFileExt(Reg, 'inc'); //..
end;

procedure TfrmMain.CheckBasePath;
var
  bPath32,
  bPath64: Boolean;
begin
  cLazBasePath := txtLazarusPath.Text;
  bPath32 := FileExists(cLazBasePath + '\bin32\lazarus.exe');
  bPath64 := FileExists(cLazBasePath + '\bin64\lazarus.exe');
  grpArch.Enabled := (bPath32 and bPath64);
  grpAssoc.Enabled := grpArch.Enabled;
  chkLazarus32.Checked := bPath32;
  chkLazarus64.Checked := bPath64;
  //
  btnSet.Enabled := (chkLazarus32.Enabled and chkLazarus64.Enabled);
end;

end.

