unit PPDK_RegFileType;

{$mode objfpc}
{$H+}

interface

uses
  Dialogs, SysUtils, StrUtils, Classes, Registry;

function GetFileExt(Reg: TRegistry; sExt: String): Boolean;
function SetFileExt(Reg: TRegistry; sExt, sDesc, sLongDesc, sMenuCaption, sCmdName, sRunCmd, sIcon: String; bIsDefault: Boolean): Boolean;
function UnSetFileExt(Reg: TRegistry; sExt: String): Boolean;
//procedure DeleteKeyRecursive(Reg: TRegistry; sPath: String);

implementation

function GetFileExt(Reg: TRegistry; sExt: String): Boolean;
var
  bRes: Boolean;
  s1,
  st: String;
begin
  bRes := false;
  Reg.RootKey := HKEY_CLASSES_ROOT;
  if(sExt[1] <> '.')then
  begin
    sExt := '.' + sExt;
  end;
  if(Reg.OpenKeyReadOnly(sExt))then
  begin
  	s1 := Reg.ReadString('');
    if(s1 <> '')then
    begin
    	Reg.CloseKey;
      if(Reg.OpenKeyReadOnly(s1))then
      begin
      	Reg.CloseKey;
        if(Reg.OpenKeyReadOnly(s1 + '\shell\open\command'))then
        begin
        	s1 := Reg.ReadString('');//RunCommand
          Reg.CloseKey;
          if(s1 <> '')then
          begin
            if(s1[1] = '"')then
            begin
            	st := MidStr(s1, 2, NPos('"', s1, 2) - 2);
            end
            else
            begin
            	st := LeftStr(s1, Pos(' ', s1) - 1);
            end;
            //ShowMessage('st-[' + st + ']');
            bRes := FileExists(st);
          end;
        end;
      end;
    end;
  end;
  Reg.CloseKey;
  Result := bRes;
end;

function SetFileExt(Reg: TRegistry; sExt, sDesc, sLongDesc, sMenuCaption, sCmdName, sRunCmd, sIcon: String; bIsDefault: Boolean): Boolean;
begin
  SetFileExt := false;
	Reg.RootKey := HKEY_CLASSES_ROOT;
  if(sExt[1] <> '.')then
  begin
  	sExt := '.' + sExt;
  end;
  if(Reg.OpenKey(sExt, true))then
  begin
  	Reg.WriteString('', sDesc);
  	Reg.CloseKey;
    if(Reg.OpenKey(sDesc, true))then
    begin
  		Reg.WriteString('', sLongDesc);
  		Reg.CloseKey;
      if(Reg.OpenKey(sDesc + '\DefaultIcon', true))then
      begin
  			Reg.WriteString('', sIcon);
  			Reg.CloseKey;
  			if(Reg.OpenKey(sDesc + '\shell\' + sCmdName, true))then
        begin
  				Reg.WriteString('', sMenuCaption);
  				Reg.CloseKey;
          if(bIsDefault)then
          begin
          	Reg.OpenKey(sDesc + '\shell', true);
          	Reg.WriteString('', sCmdName);
          	Reg.CloseKey;
          end;
  				if(Reg.OpenKey(sDesc + '\shell\' + sCmdName + '\command', true))then
        	begin
	  				Reg.WriteString('', sRunCmd);
	  				Reg.CloseKey;
	          Result := true;
	        end;
        end;
      end;
    end;
  end;
end;

procedure DeleteKeyRecursive(Reg: TRegistry; sPath: String);
var
  SL : TStringList;
  X : Integer;
begin
  if Reg.OpenKey(sPath, False) then
  begin
    SL := TStringList.Create;
  	Reg.GetKeyNames(SL);
    For X := 0 to SL.Count - 1 do
    begin
      Reg.CloseKey;
    	DeleteKeyRecursive(Reg, sPath + '\' + SL[X]);
    end;
    Reg.CloseKey;
    Reg.DeleteKey(sPath);
    SL.Free;
  end;
end;

function UnSetFileExt(Reg: TRegistry; sExt: String): Boolean;
var
  s1: String;
begin
  UnSetFileExt := false;
  if(sExt[1] <> '.')then
  begin
    sExt := '.' + sExt;
  end;
  Reg.RootKey := HKEY_CLASSES_ROOT;
	if(Reg.OpenKeyReadOnly(sExt))then
  begin
    s1 := Reg.ReadString('');
    Reg.CloseKey;
    if(s1 <> '')then
    begin
      if(Reg.OpenKeyReadOnly(s1))then
      begin
        Reg.CloseKey;
        DeleteKeyRecursive(Reg, s1);
        Reg.DeleteKey(s1);
        DeleteKeyRecursive(Reg, sExt);
        Reg.DeleteKey(sExt);
        if(Reg.OpenKeyReadOnly(s1) = false)then
        begin
          if(Reg.OpenKeyReadOnly(sExt) = false)then
          begin
          	Result := true;
          end;
        end;
      end
      else
      begin
        if(Reg.DeleteKey(sExt))then
        begin
          Result := true;
        end;
      end;
    end;
  end;
end;

end.

