{ This file contains compiler distinctions and conditional defines for all
  source files in the KControls Development Suite. It has been created from
  several similar resources available. }

{$IFNDEF KCONTROLS_INC}
  {$DEFINE KCONTROLS_INC}

{ Default compiler directives for entire KControls Development Suite }

{$IFDEF FPC}
  {$MODE DELPHI}
  {$B-,H+,J+,Q-,R-,T-,X+}
{$ELSE}
  {$B-,H+,J+,Q-,R-,T-,X+}
{$ENDIF}

{ Specifies if native operating system theme support should be used (Themes.pas is needed) }

{$DEFINE USE_THEMES}

{ COMPILERx, DELPHIx and BCBx directives from VERx }

{$IFDEF VER270}
  {$DEFINE COMPILER19}
  {$IFDEF BCB}
    {$DEFINE BCBXE6}
  {$ELSE}
    {$DEFINE DELPHIXE6}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER260}
  {$DEFINE COMPILER18}
  {$IFDEF BCB}
    {$DEFINE BCBXE5}
  {$ELSE}
    {$DEFINE DELPHIXE5}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER250}
  {$DEFINE COMPILER17}
  {$IFDEF BCB}
    {$DEFINE BCBXE4}
  {$ELSE}
    {$DEFINE DELPHIXE4}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER240}
  {$DEFINE COMPILER16}
  {$IFDEF BCB}
    {$DEFINE BCBXE3}
  {$ELSE}
    {$DEFINE DELPHIXE3}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER230}
  {$DEFINE COMPILER15}
  {$IFDEF BCB}
    {$DEFINE BCBXE2}
  {$ELSE}
    {$DEFINE DELPHIXE2}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER220}
  {$DEFINE COMPILER14}
  {$IFDEF BCB}
    {$DEFINE BCBXE}
  {$ELSE}
    {$DEFINE DELPHIXE}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER210}
  {$DEFINE COMPILER13}
  {$IFDEF BCB}
    {$DEFINE BCB2010}
  {$ELSE}
    {$DEFINE DELPHI2010}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER200}
  {$DEFINE COMPILER12}
  {$IFDEF BCB}
    {$DEFINE BCB2009}
  {$ELSE}
    {$DEFINE DELPHI2009}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER180}
  {$IFDEF VER185}
    {$DEFINE COMPILER11}
    {$IFDEF BCB}
      {$DEFINE BCB2007}
    {$ELSE}
      {$DEFINE DELPHI2007}
    {$ENDIF}
  {$ELSE}
    {$DEFINE COMPILER10}
    {$IFDEF BCB}
      {$DEFINE BCB2006}
    {$ELSE}
      {$DEFINE DELPHI2006}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER170}
  {$DEFINE COMPILER9}
  {$DEFINE DELPHI2005}
{$ENDIF}

{$IFDEF VER160}
  {$DEFINE COMPILER8}
  {$DEFINE DELPHI8}
{$ENDIF}

{$IFDEF VER150}
  {$DEFINE COMPILER7}
  {$DEFINE DELPHI7}
{$ENDIF}

{$IFDEF VER140}
  {$DEFINE COMPILER6}
  {$IFDEF BCB}
    {$DEFINE BCB6}
  {$ELSE}
    {$DEFINE DELPHI6}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER130}
  {$DEFINE COMPILER5}
  {$IFDEF BCB}
    {$DEFINE BCB5}
  {$ELSE}
    {$DEFINE DELPHI5}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER125}
  {$DEFINE COMPILER4}
  {$DEFINE BCB}
  {$DEFINE BCB4}
{$ENDIF}

{$IFDEF VER120}
  {$DEFINE COMPILER4}
  {$DEFINE DELPHI4}
{$ENDIF}

{$IFDEF VER110}
  {$DEFINE COMPILER3}
  {$DEFINE BCB}
  {$DEFINE BCB3}
{$ENDIF}

{$IFDEF VER100}
  {$DEFINE COMPILER3}
  {$DEFINE DELPHI3}
{$ENDIF}

{$IFDEF VER93}
  {$DEFINE COMPILER2}
  {$DEFINE BCB}
  {$DEFINE BCB1}
{$ENDIF}

{$IFDEF VER90}
  {$DEFINE COMPILER2}
  {$DEFINE DELPHI2}
{$ENDIF}

{ What is used: DELPHI or BCB ? (BCB is defined by C++Builder 5 and later) }

{$IFNDEF BCB}
  {$DEFINE DELPHI}
{$ENDIF}

{ COMPILERx_UP directives from COMPILERx }

{$IFDEF COMPILER19} {$DEFINE COMPILER19_UP} {$ENDIF}
{$IFDEF COMPILER18} {$DEFINE COMPILER18_UP} {$ENDIF}
{$IFDEF COMPILER17} {$DEFINE COMPILER17_UP} {$ENDIF}
{$IFDEF COMPILER16} {$DEFINE COMPILER16_UP} {$ENDIF}
{$IFDEF COMPILER15} {$DEFINE COMPILER15_UP} {$ENDIF}
{$IFDEF COMPILER14} {$DEFINE COMPILER14_UP} {$ENDIF}
{$IFDEF COMPILER13} {$DEFINE COMPILER13_UP} {$ENDIF}
{$IFDEF COMPILER12} {$DEFINE COMPILER12_UP} {$ENDIF}
{$IFDEF COMPILER11} {$DEFINE COMPILER11_UP} {$ENDIF}
{$IFDEF COMPILER10} {$DEFINE COMPILER10_UP} {$ENDIF}
{$IFDEF COMPILER9}  {$DEFINE COMPILER9_UP}  {$ENDIF}
{$IFDEF COMPILER8}  {$DEFINE COMPILER8_UP}  {$ENDIF}
{$IFDEF COMPILER7}  {$DEFINE COMPILER7_UP}  {$ENDIF}
{$IFDEF COMPILER6}  {$DEFINE COMPILER6_UP}  {$ENDIF}
{$IFDEF COMPILER5}  {$DEFINE COMPILER5_UP}  {$ENDIF}
{$IFDEF COMPILER4}  {$DEFINE COMPILER4_UP}  {$ENDIF}
{$IFDEF COMPILER3}  {$DEFINE COMPILER3_UP}  {$ENDIF}
{$IFDEF COMPILER2}  {$DEFINE COMPILER2_UP}  {$ENDIF}

{$IFDEF COMPILER19_UP} {$DEFINE COMPILER18_UP} {$ENDIF}
{$IFDEF COMPILER18_UP} {$DEFINE COMPILER17_UP} {$ENDIF}
{$IFDEF COMPILER17_UP} {$DEFINE COMPILER16_UP} {$ENDIF}
{$IFDEF COMPILER16_UP} {$DEFINE COMPILER15_UP} {$ENDIF}
{$IFDEF COMPILER15_UP} {$DEFINE COMPILER14_UP} {$ENDIF}
{$IFDEF COMPILER14_UP} {$DEFINE COMPILER13_UP} {$ENDIF}
{$IFDEF COMPILER13_UP} {$DEFINE COMPILER12_UP} {$ENDIF}
{$IFDEF COMPILER12_UP} {$DEFINE COMPILER11_UP} {$ENDIF}
{$IFDEF COMPILER11_UP} {$DEFINE COMPILER10_UP} {$ENDIF}
{$IFDEF COMPILER10_UP} {$DEFINE COMPILER9_UP}  {$ENDIF}
{$IFDEF COMPILER9_UP}  {$DEFINE COMPILER8_UP}  {$ENDIF}
{$IFDEF COMPILER8_UP}  {$DEFINE COMPILER7_UP}  {$ENDIF}
{$IFDEF COMPILER7_UP}  {$DEFINE COMPILER6_UP}  {$ENDIF}
{$IFDEF COMPILER6_UP}  {$DEFINE COMPILER5_UP}  {$ENDIF}
{$IFDEF COMPILER5_UP}  {$DEFINE COMPILER4_UP}  {$ENDIF}
{$IFDEF COMPILER4_UP}  {$DEFINE COMPILER3_UP}  {$ENDIF}
{$IFDEF COMPILER3_UP}  {$DEFINE COMPILER2_UP}  {$ENDIF}
{$IFDEF COMPILER2_UP}  {$DEFINE COMPILER1_UP}  {$ENDIF}

{ DELPHIx_UP directives from DELPHIx }

{$IFDEF DELPHIXE6} {$DEFINE DELPHIXE6_UP} {$ENDIF}
{$IFDEF DELPHIXE5} {$DEFINE DELPHIXE5_UP} {$ENDIF}
{$IFDEF DELPHIXE4} {$DEFINE DELPHIXE4_UP} {$ENDIF}
{$IFDEF DELPHIXE3} {$DEFINE DELPHIXE3_UP} {$ENDIF}
{$IFDEF DELPHIXE2} {$DEFINE DELPHIXE2_UP} {$ENDIF}
{$IFDEF DELPHIXE} {$DEFINE DELPHIXE_UP} {$ENDIF}
{$IFDEF DELPHI2010} {$DEFINE DELPHI2010_UP} {$ENDIF}
{$IFDEF DELPHI2009} {$DEFINE DELPHI2009_UP} {$ENDIF}
{$IFDEF DELPHI2007} {$DEFINE DELPHI2007_UP} {$ENDIF}
{$IFDEF DELPHI2006} {$DEFINE DELPHI2006_UP} {$ENDIF}
{$IFDEF DELPHI2005} {$DEFINE DELPHI2005_UP} {$ENDIF}
{$IFDEF DELPHI8}  {$DEFINE DELPHI8_UP}  {$ENDIF}
{$IFDEF DELPHI7}  {$DEFINE DELPHI7_UP}  {$ENDIF}
{$IFDEF DELPHI6}  {$DEFINE DELPHI6_UP}  {$ENDIF}
{$IFDEF DELPHI5}  {$DEFINE DELPHI5_UP}  {$ENDIF}
{$IFDEF DELPHI4}  {$DEFINE DELPHI4_UP}  {$ENDIF}
{$IFDEF DELPHI3}  {$DEFINE DELPHI3_UP}  {$ENDIF}
{$IFDEF DELPHI2}  {$DEFINE DELPHI2_UP}  {$ENDIF}

{$IFDEF DELPHIXE6_UP} {$DEFINE DELPHIXE5_UP} {$ENDIF}
{$IFDEF DELPHIXE5_UP} {$DEFINE DELPHIXE4_UP} {$ENDIF}
{$IFDEF DELPHIXE4_UP} {$DEFINE DELPHIXE3_UP} {$ENDIF}
{$IFDEF DELPHIXE3_UP} {$DEFINE DELPHIXE2_UP} {$ENDIF}
{$IFDEF DELPHIXE2_UP} {$DEFINE DELPHIXE_UP} {$ENDIF}
{$IFDEF DELPHIXE_UP} {$DEFINE DELPHI2010_UP} {$ENDIF}
{$IFDEF DELPHI2010_UP} {$DEFINE DELPHI2009_UP} {$ENDIF}
{$IFDEF DELPHI2009_UP} {$DEFINE DELPHI2007_UP} {$ENDIF}
{$IFDEF DELPHI2007_UP} {$DEFINE DELPHI2006_UP} {$ENDIF}
{$IFDEF DELPHI2006_UP} {$DEFINE DELPHI2005_UP} {$ENDIF}
{$IFDEF DELPHI2005_UP} {$DEFINE DELPHI8_UP}    {$ENDIF}
{$IFDEF DELPHI8_UP} {$DEFINE DELPHI7_UP} {$ENDIF}
{$IFDEF DELPHI7_UP} {$DEFINE DELPHI6_UP} {$ENDIF}
{$IFDEF DELPHI6_UP} {$DEFINE DELPHI5_UP} {$ENDIF}
{$IFDEF DELPHI5_UP} {$DEFINE DELPHI4_UP} {$ENDIF}
{$IFDEF DELPHI4_UP} {$DEFINE DELPHI3_UP} {$ENDIF}
{$IFDEF DELPHI3_UP} {$DEFINE DELPHI2_UP} {$ENDIF}
{$IFDEF DELPHI2_UP} {$DEFINE DELPHI1_UP} {$ENDIF}

{ BCBx_UP directives from BCBx }

{$IFDEF BCBXE6} {$DEFINE BCBXE6_UP} {$ENDIF}
{$IFDEF BCBXE5} {$DEFINE BCBXE5_UP} {$ENDIF}
{$IFDEF BCBXE4} {$DEFINE BCBXE4_UP} {$ENDIF}
{$IFDEF BCBXE3} {$DEFINE BCBXE3_UP} {$ENDIF}
{$IFDEF BCBXE2} {$DEFINE BCBXE2_UP} {$ENDIF}
{$IFDEF BCBXE} {$DEFINE BCBXE_UP} {$ENDIF}
{$IFDEF BCB2010} {$DEFINE BCB2010_UP} {$ENDIF}
{$IFDEF BCB2009} {$DEFINE BCB2009_UP} {$ENDIF}
{$IFDEF BCB2007} {$DEFINE BCB2007_UP} {$ENDIF}
{$IFDEF BCB2006} {$DEFINE BCB2006_UP} {$ENDIF}
{$IFDEF BCB6}  {$DEFINE BCB6_UP}  {$ENDIF}
{$IFDEF BCB5}  {$DEFINE BCB5_UP}  {$ENDIF}
{$IFDEF BCB4}  {$DEFINE BCB4_UP}  {$ENDIF}
{$IFDEF BCB3}  {$DEFINE BCB3_UP}  {$ENDIF}
{$IFDEF BCB1}  {$DEFINE BCB1_UP}  {$ENDIF}

{$IFDEF BCBXE6_UP} {$DEFINE BCBXE5_UP} {$ENDIF}
{$IFDEF BCBXE5_UP} {$DEFINE BCBXE4_UP} {$ENDIF}
{$IFDEF BCBXE4_UP} {$DEFINE BCBXE3_UP} {$ENDIF}
{$IFDEF BCBXE3_UP} {$DEFINE BCBXE2_UP} {$ENDIF}
{$IFDEF BCBXE2_UP} {$DEFINE BCBXE_UP} {$ENDIF}
{$IFDEF BCBXE_UP} {$DEFINE BCB2010_UP} {$ENDIF}
{$IFDEF BCB2010_UP} {$DEFINE BCB2009_UP} {$ENDIF}
{$IFDEF BCB2009_UP} {$DEFINE BCB2007_UP} {$ENDIF}
{$IFDEF BCB2007_UP} {$DEFINE BCB2006_UP} {$ENDIF}
{$IFDEF BCB2006_UP} {$DEFINE BCB6_UP}    {$ENDIF}
{$IFDEF BCB6_UP}  {$DEFINE BCB5_UP}  {$ENDIF}
{$IFDEF BCB5_UP}  {$DEFINE BCB4_UP}  {$ENDIF}
{$IFDEF BCB4_UP}  {$DEFINE BCB3_UP}  {$ENDIF}
{$IFDEF BCB3_UP}  {$DEFINE BCB1_UP}  {$ENDIF}

{ Unicode compiler directive for string type }
// Delphi 2009+ uses UTF16, Lazarus 0.9.25+ uses UTF8
{$IF DEFINED(COMPILER12_UP) OR DEFINED(FPC)}
  {$DEFINE STRING_IS_UNICODE}
{$IFEND}

{ Prefers usage of TCanvas methods instead of WinAPI mainly to avoid Lazarus bugs. }
{$DEFINE USE_CANVAS_METHODS}

{ Register new image formats into TPicture. }
{.$DEFINE REGISTER_PICTURE_FORMATS}

{ Allows to use WinAPI functions in Lazarus and Delphi }
{$IF NOT DEFINED(FPC) OR DEFINED(WINDOWS)}
  {$DEFINE USE_WINAPI}
{$IFEND}

{ Allows to use WideWinProcs unit }
{$IFDEF USE_WINAPI}
  {.$DEFINE USE_WIDEWINPROCS}
{$ENDIF}

{ Support Alphacontrols integration in Delphi and Lazarus,
  AlphaControlsLaz package needed for Lazarus. }
{.$DEFINE SUPPORT_ALPHASKINS}

{ Allow Alphacontrols integration to be used in Delphi }
{$IFnDEF FPC}
  {.$DEFINE USE_ALPHASKINS}
{$ENDIF}

{$IF DEFINED(SUPPORT_ALPHASKINS) OR DEFINED(USE_ALPHASKINS)}
  {$DEFINE SUPPORT_OR_USE_ALPHASKINS}
{$IFEND}

{$DEFINE LAZARUS_HAS_DC_MAPPING}

{$IF DEFINED(USE_WINAPI) OR DEFINED(LAZARUS_HAS_DC_MAPPING)}
  {$DEFINE USE_DC_MAPPING}
{$IFEND}

{ Conditional defines for unit KGrids: }
// we want TKGridObjectCell to be a descendant of TKGridAttrTextCell
{$DEFINE TKGRIDOBJECTCELL_IS_TKGRIDATTRTEXTCELL}

// we want TKGridObjectCell to be a descendant of TKGridTextCell
{.$DEFINE TKGRIDOBJECTCELL_IS_TKGRIDTEXTCELL}

// use JCLUnicode (only for TKGridAxisItem.Assign(Source: TWideStrings);)
{.$DEFINE TKGRID_USE_JCL}

{ Conditional defines for unit KDBGrids: }
// we want to use TKDBGrid
{$DEFINE TKDBGRID_USE}

// we want TKDBGridCell to be a descendant of TKGridAttrTextCell
{.$DEFINE TKDBGRIDCELL_IS_TKGRIDATTRTEXTCELL}

// PngImage can be used
{$IF DEFINED(FPC) OR DEFINED(COMPILER12_UP)}
  {$DEFINE USE_PNG_SUPPORT}
{$IFEND}

{$ENDIF ~KCONTROLS_INC}


