{**********************************************************************
                PilotLogic Software House.
    
 Package pl_BGRAcontrols.pkg
 This unit is part of CodeTyphon Studio (http://www.pilotlogic.com/)
***********************************************************************}
    
unit AllBGRAControlsRegister;

{$mode objfpc}{$H+}

interface

uses
  Classes,SysUtils,TypInfo,lresources,PropEdits,ComponentEditors, GraphPropEdits, LCLType, ImgList,
  BCBaseCtrls,
  BGRAButton,
  BGRAFlashProgressBar,
  BGRAImageList,
  BGRAKnob,
  BGRAPanel,
  BGRASpeedButton,
  BGRAImageButton,
  BGRAImageManipulation,
  BGRALabel,
  BGRALabelFX,
  BGRAShape,
  BGRAGraphicControl,
  BGRASpriteAnimation,
  BGRAWin7ToolBar,
  BGRANeoButton,
  BGRARibbon,
  BGRARibbonGroup,
  BGRAVirtualScreen,
  BGRAResizeSpeedButton,
  BCButtonFocus,
  BCRadialProgressBar,
  BCSVGViewer,
  uPSI_BGRAPascalScript,
  BCSVGButton,

  BCLabel,
  BCPanel,
  BCButton,
  BCImageButton,
  BCGameGrid,
  bcstylesform,
  BCTrackbarUpdown,
  BCToolBar,
  BCListBox,

  BCKeyboard,

  BCMDButton,BCMDButtonFocus,

  BCDefaultThemeManager,
  BCMaterialDesignButton,
  BCNumericKeyboard,
  BGRACustomDrawn,
  ColorSpeedButton,

  DTAnalogClock,
  dtthemedclock,
  DTAnalogGauge,
  dtthemedgauge;

type
  TBCButtonImageIndexPropertyEditor = class(TImageIndexPropertyEditor)
  protected
    function GetImageList: TCustomImageList; override;
  end;

  TBCButtonFocusImageIndexPropertyEditor = class(TImageIndexPropertyEditor)
  protected
    function GetImageList: TCustomImageList; override;
  end;

procedure Register;

implementation

{$R AllBGRAControlsRegister.res}

function TBCButtonImageIndexPropertyEditor.GetImageList: TCustomImageList;
var
  Component: TPersistent;
begin
  Component := GetComponent(0);
  if Component is TCustomBCButton then
    Result := TCustomBCButton(Component).Images
  else
    Result := nil
end;

function TBCButtonFocusImageIndexPropertyEditor.GetImageList: TCustomImageList;
var
  Component: TPersistent;
begin
  Component := GetComponent(0);
  if Component is TCustomBCButtonFocus then
    Result := TCustomBCButtonFocus(Component).Images
  else
    Result := nil;
end;


//==========================================================
procedure Register;
begin
  RegisterNoIcon([TBCCustomControl]);

  RegisterComponents ('BGRA Controls 1',[
                                  TBCButton,    
                                  TBCSVGButton,
                                  TBCButtonFocus,
                                  TBCXButton,
                                  TBCImageButton,
                                  TBCLabel,
                                  TBCPanel,
                                  TBCGameGrid,
                                  TBCTrackbarUpdown,
                                  TBCToolBar,
                                  TBCRadialProgressBar,

                                  TBGRAButton,
                                  TBGRANeoButton,
                                  TBGRASpeedButton,
                                  TBGRAResizeSpeedButton,
                                  TBGRAPanel,
                                  TBGRAKnob,

                                  TBGRAImageList,
                                  TBGRAFlashProgressBar,
                                  TBGRAImageButton,
                                  TBGRAWin7ToolBar,
                                  TBGRARibbon,
                                  TBGRARibbonGroup,
                                  TBGRALabel,
                                  TBGRALabelFX,
                                  TBGRAShape,
                                  TBGRAImageManipulation,
                                  TBGRAGraphicControl,
                                  TBGRASpriteAnimation,
                                  TBGRAVirtualScreen,

                                  TDTAnalogClock,
                                  TDTAnalogGauge,
                                  TDTThemedClock,
                                  TDTThemedGauge,

                                  TPSImport_bgrapascalscript
                                   ]);


  RegisterComponents ('BGRA Controls 2',[

                                  TBCDButton,
                                  TColorSpeedButton,
                                  TBCMDButton,
                                  TBCMDButtonFocus,
                                  TBCDEdit,
                                  TBCDStaticText,
                                  TBCDProgressBar,
                                  TBCDSpinEdit,
                                  TBCDCheckBox,
                                  TBCDRadioButton,
                                  TBCDPanel,
                                  TBCListBox,
                                  TBCPaperPanel,
                                  TBCPaperListBox,
                                  TBCSVGViewer,

                                  TBCDefaultThemeManager,
                                  TBCMaterialDesignButton,

                                  TBCKeyboard,  
                                  TBCNumericKeyboard,
                                  TBCRealNumericKeyboard

                                   ]);

RegisterPropertyEditor(TypeInfo(TTranslateString), TBGRALabel,'Caption', TStringMultilinePropertyEditor);
RegisterPropertyEditor(TypeInfo(Integer), TBCButton, 'ImageIndex', TBCButtonImageIndexPropertyEditor);
RegisterPropertyEditor(TypeInfo(integer), TBCButtonFocus, 'ImageIndex', TBCButtonFocusImageIndexPropertyEditor);
RegisterPropertyEditor(TypeInfo(TBCListBox), TBCPaperListBox, 'ListBox', TClassPropertyEditor);
end;

end.

