unit frmMain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, db, FileUtil, ZConnection, ZDataset, Forms, Controls,
  Graphics, Dialogs, DBGrids, DbCtrls, StdCtrls,
  sqlite3dyn;  //

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    ZConnection1: TZConnection;
    ZQuery1: TZQuery;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

//====================================== ct9999

Function PathLibrary:string;
begin
{$IFDEF Windows}
  Result := 'C:\codetyphon\CodeOcean\0_libraries\'+
             LowerCase({$i %FPCTARGETCPU%}+'-'+{$i %FPCTARGETOS%})+'\';
{$ELSE}
  Result := '/usr/local/codetyphon/CodeOcean/0_libraries/'+
             LowerCase({$i %FPCTARGETCPU%}+'-'+{$i %FPCTARGETOS%})+'/';
{$ENDIF}
end;

Function Load_sqlite3Lib:integer;
begin
 result:=0;
 result:=sqlite3dyn.InitialiseSQLite(PathLibrary+sqlite3dyn.Sqlite3Lib);
 if result=0 then result:=sqlite3dyn.InitialiseSQLite;
end;

//====================================

{ TForm1 }

procedure TForm1.FormShow(Sender: TObject);
begin
  if fileexists('CT57Test.db') then DeleteFile('CT57Test.db');  //<<== delete old database

  Load_sqlite3Lib;      //<<== init sqlite3.dll from  C:\codetyphon\CodeOcean\0_libraries

  ZConnection1.Connected := True;
  ZQuery1.SQL.Text := 'select * from department';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ZQuery1.Close;
  ZQuery1.SQL.Text := 'create table department (';
  ZQuery1.SQL.Add('dep_id               smallint             not null,');
  ZQuery1.SQL.Add('dep_name             varchar(20)          null,');
  ZQuery1.SQL.Add('dep_shname           char(5)              null,');
  ZQuery1.SQL.Add('dep_address          varchar(255)         null,');
  ZQuery1.SQL.Add('primary key  (dep_id));');
  ZQuery1.ExecSQL;
  ZQuery1.SQL.Text := 'select * from department';
  ZQuery1.Open;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ZQuery1.Open;
end;

end.

