unit pigpio_types;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

const
  WAVE_FLAG_READ = 1;
  WAVE_FLAG_TICK = 2;
  WAVE_FLAG_COUNT = 4;

  PI_I2C_RDRW_IOCTL_MAX_MSGS = 42;
  PI_I2C_M_WR = $0000;
  PI_I2C_M_RD = $0001;
  PI_I2C_M_TEN = $0010;
  PI_I2C_M_RECV_LEN = $0400;
  PI_I2C_M_NO_RD_ACK = $0800;
  PI_I2C_M_IGNORE_NAK = $1000;
  PI_I2C_M_REV_DIR_ADDR = $2000;
  PI_I2C_M_NOSTART = $4000;

  PI_MIN_GPIO = 0;
  PI_MAX_GPIO = 53;

  PI_MAX_USER_GPIO = 31;

  PI_OFF = 0;
  PI_ON = 1;
  PI_CLEAR = 0;
  PI_SET = 1;
  PI_LOW = 0;
  PI_HIGH = 1;

  PI_TIMEOUT = 2;

  PI_INPUT = 0;
  PI_OUTPUT = 1;
  PI_ALT0 = 4;
  PI_ALT1 = 5;
  PI_ALT2 = 6;
  PI_ALT3 = 7;
  PI_ALT4 = 3;
  PI_ALT5 = 2;

  PI_PUD_OFF = 0;
  PI_PUD_DOWN = 1;
  PI_PUD_UP = 2;

  PI_DEFAULT_DUTYCYCLE_RANGE = 255;
  PI_MIN_DUTYCYCLE_RANGE = 25;
  PI_MAX_DUTYCYCLE_RANGE = 40000;

  PI_SERVO_OFF = 0;
  PI_MIN_SERVO_PULSEWIDTH = 500;
  PI_MAX_SERVO_PULSEWIDTH = 2500;

  PI_HW_PWM_MIN_FREQ = 1;
  PI_HW_PWM_MAX_FREQ = 125000000;
  PI_HW_PWM_RANGE = 1000000;

  PI_HW_CLK_MIN_FREQ = 4689;
  PI_HW_CLK_MAX_FREQ = 250000000;

  PI_NOTIFY_SLOTS = 32;
  PI_NTFY_FLAGS_WDOG = 1 shl 5;

  PI_CMD_MODES = 0;
  PI_CMD_MODEG = 1;
  PI_CMD_PUD = 2;
  PI_CMD_READ = 3;
  PI_CMD_WRITE = 4;
  PI_CMD_PWM = 5;
  PI_CMD_PRS = 6;
  PI_CMD_PFS = 7;
  PI_CMD_SERVO = 8;
  PI_CMD_WDOG = 9;
  PI_CMD_BR1 = 10;
  PI_CMD_BR2 = 11;
  PI_CMD_BC1 = 12;
  PI_CMD_BC2 = 13;
  PI_CMD_BS1 = 14;
  PI_CMD_BS2 = 15;
  PI_CMD_TICK = 16;
  PI_CMD_HWVER = 17;
  PI_CMD_NO = 18;
  PI_CMD_NB = 19;
  PI_CMD_NP = 20;
  PI_CMD_NC = 21;
  PI_CMD_PRG = 22;
  PI_CMD_PFG = 23;
  PI_CMD_PRRG = 24;
  PI_CMD_HELP = 25;
  PI_CMD_PIGPV = 26;
  PI_CMD_WVCLR = 27;
  PI_CMD_WVAG = 28;
  PI_CMD_WVAS = 29;
  PI_CMD_WVGO = 30;
  PI_CMD_WVGOR = 31;
  PI_CMD_WVBSY = 32;
  PI_CMD_WVHLT = 33;
  PI_CMD_WVSM = 34;
  PI_CMD_WVSP = 35;
  PI_CMD_WVSC = 36;
  PI_CMD_TRIG = 37;
  PI_CMD_PROC = 38;
  PI_CMD_PROCD = 39;
  PI_CMD_PROCR = 40;
  PI_CMD_PROCS = 41;
  PI_CMD_SLRO = 42;
  PI_CMD_SLR = 43;
  PI_CMD_SLRC = 44;
  PI_CMD_PROCP = 45;
  PI_CMD_MICS = 46;
  PI_CMD_MILS = 47;
  PI_CMD_PARSE = 48;
  PI_CMD_WVCRE = 49;
  PI_CMD_WVDEL = 50;
  PI_CMD_WVTX = 51;
  PI_CMD_WVTXR = 52;
  PI_CMD_WVNEW = 53;
  PI_CMD_I2CO = 54;
  PI_CMD_I2CC = 55;
  PI_CMD_I2CRD = 56;
  PI_CMD_I2CWD = 57;
  PI_CMD_I2CWQ = 58;
  PI_CMD_I2CRS = 59;
  PI_CMD_I2CWS = 60;
  PI_CMD_I2CRB = 61;
  PI_CMD_I2CWB = 62;
  PI_CMD_I2CRW = 63;
  PI_CMD_I2CWW = 64;
  PI_CMD_I2CRK = 65;
  PI_CMD_I2CWK = 66;
  PI_CMD_I2CRI = 67;
  PI_CMD_I2CWI = 68;
  PI_CMD_I2CPC = 69;
  PI_CMD_I2CPK = 70;
  PI_CMD_SPIO = 71;
  PI_CMD_SPIC = 72;
  PI_CMD_SPIR = 73;
  PI_CMD_SPIW = 74;
  PI_CMD_SPIX = 75;
  PI_CMD_SERO = 76;
  PI_CMD_SERC = 77;
  PI_CMD_SERRB = 78;
  PI_CMD_SERWB = 79;
  PI_CMD_SERR = 80;
  PI_CMD_SERW = 81;
  PI_CMD_SERDA = 82;
  PI_CMD_GDC = 83;
  PI_CMD_GPW = 84;
  PI_CMD_HC = 85;
  PI_CMD_HP = 86;
  PI_CMD_CF1 = 87;
  PI_CMD_CF2 = 88;
  PI_CMD_NOIB = 99;
  PI_CMD_SCRIPT = 800;
  PI_CMD_ADD = 800;
  PI_CMD_AND = 801;
  PI_CMD_CALL = 802;
  PI_CMD_CMDR = 803;
  PI_CMD_CMDW = 804;
  PI_CMD_CMP = 805;
  PI_CMD_DCR = 806;
  PI_CMD_DCRA = 807;
  PI_CMD_DIV = 808;
  PI_CMD_HALT = 809;
  PI_CMD_INR = 810;
  PI_CMD_INRA = 811;
  PI_CMD_JM = 812;
  PI_CMD_JMP = 813;
  PI_CMD_JNZ = 814;
  PI_CMD_JP = 815;
  PI_CMD_JZ = 816;
  PI_CMD_TAG = 817;
  PI_CMD_LD = 818;
  PI_CMD_LDA = 819;
  PI_CMD_LDAB = 820;
  PI_CMD_MLT = 821;
  PI_CMD_MOD = 822;
  PI_CMD_NOP = 823;
  PI_CMD_OR = 824;
  PI_CMD_POP = 825;
  PI_CMD_POPA = 826;
  PI_CMD_PUSH = 827;
  PI_CMD_PUSHA = 828;
  PI_CMD_RET = 829;
  PI_CMD_RL = 830;
  PI_CMD_RLA = 831;
  PI_CMD_RR = 832;
  PI_CMD_RRA = 833;
  PI_CMD_STA = 834;
  PI_CMD_STAB = 835;
  PI_CMD_SUB = 836;
  PI_CMD_SYS = 837;
  PI_CMD_WAIT = 838;
  PI_CMD_X = 839;
  PI_CMD_XA = 840;
  PI_CMD_XOR = 841;

  PI_INIT_FAILED = -1;
  PI_BAD_USER_GPIO = -2;
  PI_BAD_GPIO = -3;
  PI_BAD_MODE = -4;
  PI_BAD_LEVEL = -5;
  PI_BAD_PUD = -6;
  PI_BAD_PULSEWIDTH = -7;
  PI_BAD_DUTYCYCLE = -8;
  PI_BAD_TIMER = -9;
  PI_BAD_MS = -10;
  PI_BAD_TIMETYPE = -11;
  PI_BAD_SECONDS = -12;
  PI_BAD_MICROS = -13;
  PI_TIMER_FAILED = -14;
  PI_BAD_WDOG_TIMEOUT = -15;
  PI_NO_ALERT_FUNC = -16;
  PI_BAD_CLK_PERIPH = -17;
  PI_BAD_CLK_SOURCE = -18;
  PI_BAD_CLK_MICROS = -19;
  PI_BAD_BUF_MILLIS = -20;
  PI_BAD_DUTYRANGE = -21;
  PI_BAD_DUTY_RANGE = -21;
  PI_BAD_SIGNUM = -22;
  PI_BAD_PATHNAME = -23;
  PI_NO_HANDLE = -24;
  PI_BAD_HANDLE = -25;
  PI_BAD_IF_FLAGS = -26;
  PI_BAD_CHANNEL = -27;
  PI_BAD_PRIM_CHANNEL = -27;
  PI_BAD_SOCKET_PORT = -28;
  PI_BAD_FIFO_COMMAND = -29;
  PI_BAD_SECO_CHANNEL = -30;
  PI_NOT_INITIALISED = -31;
  PI_INITIALISED = -32;
  PI_BAD_WAVE_MODE = -33;
  PI_BAD_CFG_INTERNAL = -34;
  PI_BAD_WAVE_BAUD = -35;
  PI_TOO_MANY_PULSES = -36;
  PI_TOO_MANY_CHARS = -37;
  PI_NOT_SERIAL_GPIO = -38;
  PI_BAD_SERIAL_STRUC = -39;
  PI_BAD_SERIAL_BUF = -40;
  PI_NOT_PERMITTED = -41;
  PI_SOME_PERMITTED = -42;
  PI_BAD_WVSC_COMMND = -43;
  PI_BAD_WVSM_COMMND = -44;
  PI_BAD_WVSP_COMMND = -45;
  PI_BAD_PULSELEN = -46;
  PI_BAD_SCRIPT = -47;
  PI_BAD_SCRIPT_ID = -48;
  PI_BAD_SER_OFFSET = -49;
  PI_GPIO_IN_USE = -50;
  PI_BAD_SERIAL_COUNT = -51;
  PI_BAD_PARAM_NUM = -52;
  PI_DUP_TAG = -53;
  PI_TOO_MANY_TAGS = -54;
  PI_BAD_SCRIPT_CMD = -55;
  PI_BAD_VAR_NUM = -56;
  PI_NO_SCRIPT_ROOM = -57;
  PI_NO_MEMORY = -58;
  PI_SOCK_READ_FAILED = -59;
  PI_SOCK_WRIT_FAILED = -60;
  PI_TOO_MANY_PARAM = -61;
  PI_NOT_HALTED = -62;
  PI_BAD_TAG = -63;
  PI_BAD_MICS_DELAY = -64;
  PI_BAD_MILS_DELAY = -65;
  PI_BAD_WAVE_ID = -66;
  PI_TOO_MANY_CBS = -67;
  PI_TOO_MANY_OOL = -68;
  PI_EMPTY_WAVEFORM = -69;
  PI_NO_WAVEFORM_ID = -70;
  PI_I2C_OPEN_FAILED = -71;
  PI_SER_OPEN_FAILED = -72;
  PI_SPI_OPEN_FAILED = -73;
  PI_BAD_I2C_BUS = -74;
  PI_BAD_I2C_ADDR = -75;
  PI_BAD_SPI_CHANNEL = -76;
  PI_BAD_FLAGS = -77;
  PI_BAD_SPI_SPEED = -78;
  PI_BAD_SER_DEVICE = -79;
  PI_BAD_SER_SPEED = -80;
  PI_BAD_PARAM = -81;
  PI_I2C_WRITE_FAILED = -82;
  PI_I2C_READ_FAILED = -83;
  PI_BAD_SPI_COUNT = -84;
  PI_SER_WRITE_FAILED = -85;
  PI_SER_READ_FAILED = -86;
  PI_SER_READ_NO_DATA = -87;
  PI_UNKNOWN_COMMAND = -88;
  PI_SPI_XFER_FAILED = -89;
  PI_BAD_POINTER = -90;
  PI_NO_AUX_SPI = -91;
  PI_NOT_PWM_GPIO = -92;
  PI_NOT_SERVO_GPIO = -93;
  PI_NOT_HCLK_GPIO = -94;
  PI_NOT_HPWM_GPIO = -95;
  PI_BAD_HPWM_FREQ = -96;
  PI_BAD_HPWM_DUTY = -97;
  PI_BAD_HCLK_FREQ = -98;
  PI_BAD_HCLK_PASS = -99;
  PI_HPWM_ILLEGAL = -100;
  PI_BAD_DATABITS = -101;
  PI_BAD_STOPBITS = -102;
  PI_MSG_TOOBIG = -103;
  PI_BAD_MALLOC_MODE = -104;
  PI_TOO_MANY_PARTS = -105;
  PI_BAD_I2C_PART = -106;
  PI_PIGIF_ERR_0 = -2000;
  PI_PIGIF_ERR_99 = -2099;
  PI_CUSTOM_ERR_0 = -3000;
  PI_CUSTOM_ERR_999 = -3999;

  PI_CLOCK_PWM = 0;
  PI_CLOCK_PCM = 1;

  PI_MEM_ALLOC_AUTO = 0;
  PI_MEM_ALLOC_PAGEMAP = 1;
  PI_MEM_ALLOC_MAILBOX = 2;

  PI_DEFAULT_BUFFER_MILLIS = 120;
  PI_DEFAULT_CLK_MICROS = 5;
  PI_DEFAULT_CLK_PERIPHERAL = PI_CLOCK_PCM;
  PI_DEFAULT_IF_FLAGS = 0;
  PI_DEFAULT_DMA_CHANNEL = 14;
  PI_DEFAULT_DMA_PRIMARY_CHANNEL = 14;
  PI_DEFAULT_DMA_SECONDARY_CHANNEL = 5;
  PI_DEFAULT_SOCKET_PORT = 8888;
  PI_DEFAULT_SOCKET_PORT_STR = '8888';
  PI_DEFAULT_SOCKET_ADDR_STR = '127.0.0.1';
  PI_DEFAULT_UPDATE_MASK_R0 = $FFFFFFFF;
  PI_DEFAULT_UPDATE_MASK_R1 = $03E7CF93;
  PI_DEFAULT_UPDATE_MASK_R2 = $FBC7CF9C;
  PI_DEFAULT_UPDATE_MASK_R3 = $0080400FFFFFFC;
  PI_DEFAULT_UPDATE_MASK_COMPUTE = $00FFFFFFFFFFFF;
  PI_DEFAULT_MEM_ALLOC_MODE = PI_MEM_ALLOC_AUTO;

  PI_WAVE_BLOCKS = 4;
  PI_WAVE_MAX_PULSES = (PI_WAVE_BLOCKS * 3000);
  PI_WAVE_MAX_CHARS = (PI_WAVE_BLOCKS *  300);

  PI_BB_MIN_BAUD = 50;
  PI_BB_RX_MAX_BAUD = 250000;
  PI_BB_TX_MAX_BAUD = 1000000;
  PI_MIN_WAVE_DATABITS = 1;
  PI_MAX_WAVE_DATABITS = 32;
  PI_MIN_WAVE_HALFSTOPBITS = 2;
  PI_MAX_WAVE_HALFSTOPBITS = 8;

  PI_WAVE_MAX_MICROS = (30*60)*1000000;
  PI_MAX_WAVES = 512;

  PI_WAVE_MODE_ONE_SHOT = 0;
  PI_WAVE_MODE_REPEAT = 1;

  MIN_SPI_SPEED = 32000;
  MAX_SPI_SPEED = 125000000;
  PI_I2C_SLOTS = 32;
  PI_SPI_SLOTS = 16;
  PI_SER_SLOTS = 8;
  PI_NUM_I2C_BUS = 2;
  PI_NUM_AUX_SPI_CHANNEL = 3;
  PI_NUM_STD_SPI_CHANNEL = 2;
  PI_MAX_I2C_DEVICE_COUNT = 1 shl 16;
  PI_MAX_SPI_DEVICE_COUNT = 1 shl 16;

  PI_MAX_BUSY_DELAY = 100;

  PI_MIN_WDOG_TIMEOUT = 0;
  PI_MAX_WDOG_TIMEOUT = 60000;

  PI_MIN_TIMER = 0;
  PI_MAX_TIMER = 9;

  PI_MIN_MS = 10;
  PI_MAX_MS = 60000;
  PI_MAX_SCRIPTS = 32;
  PI_MAX_SCRIPT_TAGS = 50;
  PI_MAX_SCRIPT_VARS = 150;
  PI_MAX_SCRIPT_PARAMS = 10;

  PI_SCRIPT_INITING = 0;
  PI_SCRIPT_HALTED = 1;
  PI_SCRIPT_RUNNING = 2;
  PI_SCRIPT_WAITING = 3;
  PI_SCRIPT_FAILED = 4;

  PI_MIN_SIGNUM = 0;
  PI_MAX_SIGNUM = 63;

  PI_TIME_RELATIVE = 0;
  PI_TIME_ABSOLUTE = 1;

  PI_MAX_MICS_DELAY = 1000000;

  PI_MAX_MILS_DELAY = 60000;

  PI_BUF_MILLIS_MIN = 100;
  PI_BUF_MILLIS_MAX = 10000;

  PI_MIN_DMA_CHANNEL = 0;
  PI_MAX_DMA_CHANNEL = 14;
  PI_MAX_PRIMARY_CHANNEL = 14;
  PI_MAX_SECONDARY_CHANNEL = 6;

  PI_MIN_SOCKET_PORT = 1024;
  PI_MAX_SOCKET_PORT = 32000;

  PI_DISABLE_FIFO_IF = 1;
  PI_DISABLE_SOCK_IF = 2;

type
  PThread = pointer;
  TSize = uint32;

  PgpioHeader = ^TgpioHeader;
  TgpioHeader = record
      func : uint16;
      size : uint16;
    end;

  PgpioExtent = ^TgpioExtent;
  TgpioExtent = record
      size : TSize;  //size_t??
      ptr  : pointer;
      data : uint32;
    end;

  PgpioSample = ^TgpioSample;
  TgpioSample = record
      tick : uint32;
      level : uint32;
    end;

  PgpioReport = ^TgpioReport;
  TgpioReport = record
      seqno : uint16;
      flags : uint16;
      tick : uint32;
      level : uint32;
    end;

  PgpioPulse = ^TgpioPulse;
  TgpioPulse = record
      gpioOn : uint32;
      gpioOff : uint32;
      usDelay : uint32;
    end;

  PrawWave = ^TrawWave;
  TrawWave = record
      gpioOn : uint32;
      gpioOff : uint32;
      usDelay : uint32;
      flags : uint32;
    end;

  PrawWaveInfo = ^TrawWaveInfo;
  TrawWaveInfo = record
      botCB : uint16;
      topCB : uint16;
      botOOL : uint16;
      topOOL : uint16;
    end;

  PrawSPI = ^TrawSPI;
  TrawSPI = record
      clk : longint;
      mosi : longint;
      miso : longint;
      ss_pol : longint;
      ss_us : longint;
      clk_pol : longint;
      clk_pha : longint;
      clk_us : longint;
    end;

  PrawCbs = ^TrawCbs;
  TrawCbs = record
      info : uint32;
      src : uint32;
      dst : uint32;
      length : uint32;
      stride : uint32;
      next : uint32;
      pad : array[0..1] of uint32;
    end;

  Ppi_i2c_msg = ^Tpi_i2c_msg;
  Tpi_i2c_msg = record
      addr : uint16;
      flags : uint16;
      len : uint16;
      buf : Puint8;
    end;

  TgpioAlertFunc = procedure (gpio:longint; level:longint; tick:uint32); cdecl;
  TgpioAlertFuncEx = procedure (gpio:longint; level:longint; tick:uint32; var userdata:pointer); cdecl;
  TgpioTimerFunc = procedure (para1:pointer); cdecl;
  TgpioTimerFuncEx = procedure (var userdata:pointer); cdecl;
  TgpioSignalFunc = procedure (signum:longint); cdecl;
  TgpioSignalFuncEx = procedure (signum:longint; var userdata:pointer); cdecl;
  TgpioGetSamplesFunc = procedure (var samples:TgpioSample; numSamples:longint); cdecl;
  TgpioGetSamplesFuncEx = procedure (var samples:TgpioSample; numSamples:longint; var userdata:pointer); cdecl;
  TgpioThreadFunc = procedure (para1:pointer); cdecl;

implementation

end.

