unit pigpio;

{$mode objfpc}{$H+}

interface

{$linklib rt}
{$linklib pthread}
{$linklib libgcc}
{$linklib libpigpio.a}

uses
  pigpio_types;

const
  PIGPIO_VERSION = 31;

  PI_INPFIFO = '/dev/pigpio';  
  PI_OUTFIFO = '/dev/pigout';  
  PI_ERRFIFO = '/dev/pigerr';  
  PI_ENVPORT = 'PIGPIO_PORT';  
  PI_ENVADDR = 'PIGPIO_ADDR';  
  PI_LOCKFILE = '/var/run/pigpio.pid';  
  PI_I2C_COMBINED = '/sys/module/i2c_bcm2708/parameters/combined';  


  function PI_NTFY_FLAGS_BIT(x : longint) : longint;
  function PI_SPI_FLAGS_BITLEN(x : longint) : longint;    
  function PI_SPI_FLAGS_RX_LSB(x : longint) : longint;    
  function PI_SPI_FLAGS_TX_LSB(x : longint) : longint;    
  function PI_SPI_FLAGS_3WREN(x : longint) : longint;    
  function PI_SPI_FLAGS_3WIRE(x : longint) : longint;    
  function PI_SPI_FLAGS_AUX_SPI(x : longint) : longint;    
  function PI_SPI_FLAGS_RESVD(x : longint) : longint;    
  function PI_SPI_FLAGS_CSPOLS(x : longint) : longint;    
  function PI_SPI_FLAGS_MODE(x : longint) : longint;    

  function gpioInitialise:longint; cdecl; external;
  procedure gpioTerminate; cdecl; external;

  function gpioSetMode(gpio:dword; mode:dword):longint; cdecl; external;
  function gpioGetMode(gpio:dword):longint; cdecl; external;
  function gpioSetPullUpDown(gpio:dword; pud:dword):longint; cdecl; external;

  function gpioRead(gpio:dword):longint; cdecl; external;
  function gpioWrite(gpio:dword; level:dword):longint; cdecl; external;

  function gpioPWM(user_gpio:dword; dutycycle:dword):longint; cdecl; external;
  function gpioGetPWMdutycycle(user_gpio:dword):longint; cdecl; external;
  function gpioSetPWMrange(user_gpio:dword; range:dword):longint; cdecl; external;
  function gpioGetPWMrange(user_gpio:dword):longint; cdecl; external;
  function gpioGetPWMrealRange(user_gpio:dword):longint; cdecl; external;
  function gpioSetPWMfrequency(user_gpio:dword; frequency:dword):longint; cdecl; external;
  function gpioGetPWMfrequency(user_gpio:dword):longint; cdecl; external;

  function gpioServo(user_gpio:dword; pulsewidth:dword):longint; cdecl; external;
  function gpioGetServoPulsewidth(user_gpio:dword):longint; cdecl; external;

  function gpioSetAlertFunc(user_gpio:dword; f:TgpioAlertFunc):longint; cdecl; external;
  function gpioSetAlertFuncEx(user_gpio:dword; f:TgpioAlertFuncEx; var userdata:pointer):longint; cdecl; external;

  function gpioNotifyOpen:longint; cdecl; external;
  function gpioNotifyBegin(handle:dword; bits:uint32):longint; cdecl; external;
  function gpioNotifyPause(handle:dword):longint; cdecl; external;
  function gpioNotifyClose(handle:dword):longint; cdecl; external;

  function gpioWaveClear:longint; cdecl; external;
  function gpioWaveAddNew:longint; cdecl; external;
  function gpioWaveAddGeneric(numPulses:dword; var pulses:TgpioPulse):longint; cdecl; external;
  function gpioWaveAddSerial(user_gpio:dword; bbBaud:dword; bbBits:dword; bbStop:dword; offset:dword; 
			   numBytes:dword; str:Pchar):longint; cdecl; external;
  function gpioWaveCreate:longint; cdecl; external;
  function gpioWaveDelete(wave_id:dword):longint; cdecl; external;
  function gpioWaveTxStart(wave_mode:dword):longint; cdecl; external;
  function gpioWaveTxSend(wave_id:dword; wave_mode:dword):longint; cdecl; external;
  function gpioWaveTxBusy:longint; cdecl; external;
  function gpioWaveTxStop:longint; cdecl; external;
  function gpioWaveGetMicros:longint; cdecl; external;
  function gpioWaveGetHighMicros:longint; cdecl; external;
  function gpioWaveGetMaxMicros:longint; cdecl; external;
  function gpioWaveGetPulses:longint; cdecl; external;
  function gpioWaveGetHighPulses:longint; cdecl; external;
  function gpioWaveGetMaxPulses:longint; cdecl; external;
  function gpioWaveGetCbs:longint; cdecl; external;
  function gpioWaveGetHighCbs:longint; cdecl; external;
  function gpioWaveGetMaxCbs:longint; cdecl; external;

  function gpioSerialReadOpen(user_gpio:dword; bbBaud:dword; bbBits:dword):longint; cdecl; external;
  function gpioSerialRead(user_gpio:dword; var buf:pointer; bufSize:uint16):longint; cdecl; external;
  function gpioSerialReadClose(user_gpio:dword):longint; cdecl; external;

  function i2cOpen(i2cBus:dword; i2cAddr:dword; i2cFlags:dword):longint; cdecl; external;
  function i2cClose(handle:dword):longint; cdecl; external;
  function i2cReadDevice(handle:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function i2cWriteDevice(handle:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function i2cTransaction(handle:dword; var parts:Tpi_i2c_msg; numParts:dword):longint; cdecl; external;
  function i2cWriteQuick(handle:dword; bit:dword):longint; cdecl; external;
  function i2cWriteByte(handle:dword; bVal:dword):longint; cdecl; external;
  function i2cReadByte(handle:dword):longint; cdecl; external;
  function i2cWriteByteData(handle:dword; i2cReg:dword; bVal:dword):longint; cdecl; external;
  function i2cWriteWordData(handle:dword; i2cReg:dword; wVal:dword):longint; cdecl; external;
  function i2cReadByteData(handle:dword; i2cReg:dword):longint; cdecl; external;
  function i2cReadWordData(handle:dword; i2cReg:dword):longint; cdecl; external;
  function i2cProcessCall(handle:dword; i2cReg:dword; wVal:dword):longint; cdecl; external;
  function i2cWriteBlockData(handle:dword; i2cReg:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function i2cReadBlockData(handle:dword; i2cReg:dword; buf:Pchar):longint; cdecl; external;
  function i2cBlockProcessCall(handle:dword; i2cReg:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function i2cReadI2CBlockData(handle:dword; i2cReg:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function i2cWriteI2CBlockData(handle:dword; i2cReg:dword; buf:Pchar; count:dword):longint; cdecl; external;

  function spiOpen(spiChan:dword; spiBaud:dword; spiFlags:dword):longint; cdecl; external;
  function spiClose(handle:dword):longint; cdecl; external;
  function spiRead(handle:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function spiWrite(handle:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function spiXfer(handle:dword; txBuf:Pchar; rxBuf:Pchar; count:dword):longint; cdecl; external;

  function serOpen(sertty:Pchar; serBaud:dword; serFlags:dword):longint; cdecl; external;
  function serClose(handle:dword):longint; cdecl; external;
  function serWriteByte(handle:dword; bVal:dword):longint; cdecl; external;
  function serReadByte(handle:dword):longint; cdecl; external;
  function serWrite(handle:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function serRead(handle:dword; buf:Pchar; count:dword):longint; cdecl; external;
  function serDataAvailable(handle:dword):longint; cdecl; external;

  function gpioTrigger(user_gpio:dword; pulseLen:dword; level:dword):longint; cdecl; external;
  function gpioSetWatchdog(user_gpio:dword; timeout:dword):longint; cdecl; external;
  function gpioSetGetSamplesFunc(f:TgpioGetSamplesFunc; bits:uint32):longint; cdecl; external;
  function gpioSetGetSamplesFuncEx(f:TgpioGetSamplesFuncEx; bits:uint32; var userdata:pointer):longint; cdecl; external;
  function gpioSetTimerFunc(timer:dword; millis:dword; f:TgpioTimerFunc):longint; cdecl; external;
  function gpioSetTimerFuncEx(timer:dword; millis:dword; f:TgpioTimerFuncEx; var userdata:pointer):longint; cdecl; external;

  function gpioStartThread(f:TgpioThreadFunc; var arg:pointer):Pthread; cdecl; external;
  procedure gpioStopThread(var pth:pthread); cdecl; external;

  function gpioStoreScript(script:Pchar):longint; cdecl; external;
  function gpioRunScript(script_id:dword; numPar:dword; var param:uint32):longint; cdecl; external;
  function gpioScriptStatus(script_id:dword; var param:uint32):longint; cdecl; external;
  function gpioStopScript(script_id:dword):longint; cdecl; external;
  function gpioDeleteScript(script_id:dword):longint; cdecl; external;

  function gpioSetSignalFunc(signum:dword; f:TgpioSignalFunc):longint; cdecl; external;
  function gpioSetSignalFuncEx(signum:dword; f:TgpioSignalFuncEx; var userdata:pointer):longint; cdecl; external;

  function gpioRead_Bits_0_31:uint32; cdecl; external;
  function gpioRead_Bits_32_53:uint32; cdecl; external;

  function gpioWrite_Bits_0_31_Clear(bits:uint32):longint; cdecl; external;
  function gpioWrite_Bits_32_53_Clear(bits:uint32):longint; cdecl; external;
  function gpioWrite_Bits_0_31_Set(bits:uint32):longint; cdecl; external;
  function gpioWrite_Bits_32_53_Set(bits:uint32):longint; cdecl; external;

  function gpioHardwareClock(gpio:dword; clkfreq:dword):longint; cdecl; external;
  function gpioHardwarePWM(gpio:dword; PWMfreq:dword; PWMduty:dword):longint; cdecl; external;
  function gpioTime(timetype:dword; var seconds:longint; var micros:longint):longint; cdecl; external;
  function gpioSleep(timetype:dword; seconds:longint; micros:longint):longint; cdecl; external;
  function gpioDelay(micros:uint32):uint32; cdecl; external;
  function gpioTick:uint32; cdecl; external;

  function gpioHardwareRevision:dword; cdecl; external;
  function gpioVersion:dword; cdecl; external;

  function gpioCfgBufferSize(cfgMillis:dword):longint; cdecl; external;
  function gpioCfgClock(cfgMicros:dword; cfgPeripheral:dword; cfgSource:dword):longint; cdecl; external;
  function gpioCfgDMAchannel(DMAchannel:dword):longint; cdecl; external;
  function gpioCfgDMAchannels(primaryChannel:dword; secondaryChannel:dword):longint; cdecl; external;
  function gpioCfgPermissions(updateMask:uint64):longint; cdecl; external;
  function gpioCfgSocketPort(port:dword):longint; cdecl; external;
  function gpioCfgInterfaces(ifFlags:dword):longint; cdecl; external;
  function gpioCfgMemAlloc(memAllocMode:dword):longint; cdecl; external;
  function gpioCfgInternals(cfgWhat:dword; cfgVal:longint):longint; cdecl; external;

  function gpioCustom1(arg1:dword; arg2:dword; argx:Pchar; argc:dword):longint; cdecl; external;
  function gpioCustom2(arg1:dword; argx:Pchar; argc:dword; retBuf:Pchar; retMax:dword):longint; cdecl; external;

  function rawWaveAddSPI(var spi:TrawSPI; offset:dword; spiSS:dword; buf:Pchar; spiTxBits:dword;
			    spiBitFirst:dword; spiBitLast:dword; spiBits:dword):longint; cdecl; external;
  function rawWaveAddGeneric(numPulses:dword; var pulses:TrawWave):longint; cdecl; external;
  function rawWaveCB:dword; cdecl; external;
  function rawWaveCBAdr(cbNum:longint):PrawCbs; cdecl; external;
  function rawWaveGetOut(pos:longint):uint32; cdecl; external;
  procedure rawWaveSetOut(pos:longint; lVal:uint32); cdecl; external;
  function rawWaveGetIn(pos:longint):uint32; cdecl; external;
  procedure rawWaveSetIn(pos:longint; lVal:uint32); cdecl; external;
  function rawWaveInfo(wave_id:longint):TrawWaveInfo; cdecl; external;

  function getBitInBytes(bitPos:longint; buf:Pchar; numBits:longint):longint; cdecl; external;
  procedure putBitInBytes(bitPos:longint; buf:Pchar; bit:longint); cdecl; external;

  function time_time:double; cdecl; external;
  procedure time_sleep(seconds:double); cdecl; external;

  procedure rawDumpWave; cdecl; external;
  procedure rawDumpScript(script_id:dword); cdecl; external;

implementation

  function PI_NTFY_FLAGS_BIT(x : longint) : longint;
  begin
    PI_NTFY_FLAGS_BIT:=(x shl 0) and 31;
  end;

  function PI_SPI_FLAGS_BITLEN(x : longint) : longint;
  begin
    PI_SPI_FLAGS_BITLEN:=(x and 63) shl 16;
  end;

  function PI_SPI_FLAGS_RX_LSB(x : longint) : longint;
  begin
    PI_SPI_FLAGS_RX_LSB:=(x and 1) shl 15;
  end;

  function PI_SPI_FLAGS_TX_LSB(x : longint) : longint;
  begin
    PI_SPI_FLAGS_TX_LSB:=(x and 1) shl 14;
  end;

  function PI_SPI_FLAGS_3WREN(x : longint) : longint;
  begin
    PI_SPI_FLAGS_3WREN:=(x and 15) shl 10;
  end;

  function PI_SPI_FLAGS_3WIRE(x : longint) : longint;
  begin
    PI_SPI_FLAGS_3WIRE:=(x and 1) shl 9;
  end;

  function PI_SPI_FLAGS_AUX_SPI(x : longint) : longint;
  begin
    PI_SPI_FLAGS_AUX_SPI:=(x and 1) shl 8;
  end;

  function PI_SPI_FLAGS_RESVD(x : longint) : longint;
  begin
    PI_SPI_FLAGS_RESVD:=(x and 7) shl 5;
  end;

  function PI_SPI_FLAGS_CSPOLS(x : longint) : longint;
  begin
    PI_SPI_FLAGS_CSPOLS:=(x and 7) shl 2;
  end;

  function PI_SPI_FLAGS_MODE(x : longint) : longint;
  begin
    PI_SPI_FLAGS_MODE:=x and 3;
  end;

end.
