unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, ExtCtrls;

type
  TLEDDirection = (ledUp, ledDown);

  { TfrmMain }

  TfrmMain = class(TForm)
    btnClose: TBitBtn;
    chkbxLED0: TCheckBox;
    chkbxLED1: TCheckBox;
    chkbxLED2: TCheckBox;
    chkbxLED3: TCheckBox;
    chkbxLED4: TCheckBox;
    chkbxLED5: TCheckBox;
    chkbxLED6: TCheckBox;
    chkbxLED7: TCheckBox;
    chkbxLEDAll: TCheckBox;
    grpboxLEDs: TGroupBox;
    tglbtnVUMeter: TToggleBox;
    tglbtnIndividual: TToggleBox;
    tglbtnCylon: TToggleBox;
    tglbtnUpDown: TToggleBox;
    tmrControl: TTimer;
    procedure chkbxLED2Click(Sender: TObject);
    procedure chkbxLED3Click(Sender: TObject);
    procedure chkbxLED4Click(Sender: TObject);
    procedure chkbxLED5Click(Sender: TObject);
    procedure chkbxLED0Click(Sender: TObject);
    procedure chkbxLED1Click(Sender: TObject);
    procedure chkbxLED6Click(Sender: TObject);
    procedure chkbxLED7Click(Sender: TObject);

    procedure chkbxClearAll;
    procedure chkbxSetAll;

    procedure AllLEDsOn;
    procedure AllLEDsOff;
    procedure chkbxLEDAllClick(Sender: TObject);
    procedure LEDOn(anLED:Integer);
    procedure LEDOff(anLED:Integer);

    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure tglbtnCylonChange(Sender: TObject);
    procedure tglbtnVUMeterChange(Sender: TObject);
    procedure tglbtnIndividualChange(Sender: TObject);
    procedure tglbtnUpDownChange(Sender: TObject);
    procedure tmrControlTimer(Sender: TObject);
  private
    { private declarations }
    FLEDDirection : TLEDDirection;
    FLEDPosition : Integer;
  public
    { public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses pigpio, pigpio_types;

{$R *.lfm}

{ TfrmMain }

const
  LED0 = 4;
  LED1 = 17;
  LED2 = 27;
  LED3 = 18;
  LED4 = 22;
  LED5 = 23;
  LED6 = 24;
  LED7 = 25;

procedure TfrmMain.FormActivate(Sender: TObject);
var errMsg:String;
begin
  if FileExists(PI_LOCKFILE) then begin
    errMsg := 'Library already running...'
               +#13#10+#13#10+'If you are running the pigpio daemon - "pigpiod" (check via "ps -ef | grep pigpiod")'
               +' then you can''t use the pigpio library directly (kill it or use pipes instead)'
               +' or possibly just remove the lock file at "/var/run/pigpio.pid" - ensure you call "gpioTerminate"'
               +' when you close your application!)';
    ShowMessage(errMsg);
    Close;
  end else if gpioInitialise < 0 then begin
    ShowMessage('Couldn''t initialize the PIGPIO library is it installed?');
    Close;
  end;

  gpioSetMode(LED0,PI_OUTPUT);
  gpioSetMode(LED1,PI_OUTPUT);
  gpioSetMode(LED2,PI_OUTPUT);
  gpioSetMode(LED3,PI_OUTPUT);
  gpioSetMode(LED4,PI_OUTPUT);
  gpioSetMode(LED5,PI_OUTPUT);
  gpioSetMode(LED6,PI_OUTPUT);
  gpioSetMode(LED7,PI_OUTPUT);

  AllLEDsOff;
  tglbtnIndividual.Checked:=True;
  FLEDDirection := ledUp;
  FLEDPosition := 0;
  Randomize;
end;

procedure TfrmMain.tglbtnCylonChange(Sender: TObject);
begin
  if tglbtnCylon.State = cbChecked then begin
    grpboxLEDs.Enabled := False;
    AllLEDsOff;
    chkbxClearAll;
    tglbtnUpDown.State:= cbUnchecked;
    tglbtnVUMeter.State := cbUnchecked;
    tglbtnIndividual.State := cbUnchecked;
    tmrControl.Enabled:=True;
  end else begin
    tglbtnIndividual.Checked:=True;
  end;
end;

procedure TfrmMain.tglbtnVUMeterChange(Sender: TObject);
begin
  if tglbtnVUMeter.State = cbChecked then begin
    grpboxLEDs.Enabled := False;
    AllLEDsOff;
    chkbxClearAll;
    tglbtnUpDown.State:= cbUnchecked;
    tglbtnCylon.State := cbUnchecked;
    tglbtnIndividual.State := cbUnchecked;
    tmrControl.Enabled:=True;
  end else begin
    tglbtnIndividual.Checked:=True;
  end;
end;

procedure TfrmMain.tglbtnIndividualChange(Sender: TObject);
begin
  if tglbtnIndividual.State = cbChecked then begin
    grpboxLEDs.Enabled := True;
    AllLEDsOff;
    chkbxClearAll;
    tglbtnUpDown.State:= cbUnchecked;
    tglbtnCylon.State:= cbUnchecked;
    tglbtnVUMeter.State := cbUnchecked;
    tmrControl.Enabled:=False;
  end else begin
    tglbtnIndividual.Checked:=True;
  end;
end;

procedure TfrmMain.tglbtnUpDownChange(Sender: TObject);
begin
  if tglbtnUpDown.State = cbChecked then begin
    grpboxLEDs.Enabled := False;
    AllLEDsOff;
    chkbxClearAll;
    tglbtnCylon.State:= cbUnchecked;
    tglbtnVUMeter.State := cbUnchecked;
    tglbtnIndividual.State := cbUnchecked;
    tmrControl.Enabled:=True;
  end else begin
    tglbtnIndividual.Checked:=True;
  end;
end;

procedure TfrmMain.LEDOn(anLED:Integer);
begin
  case anLED of
    0 : gpioWrite(LED0,1);
    1 : gpioWrite(LED1,1);
    2 : gpioWrite(LED2,1);
    3 : gpioWrite(LED3,1);
    4 : gpioWrite(LED4,1);
    5 : gpioWrite(LED5,1);
    6 : gpioWrite(LED6,1);
    7 : gpioWrite(LED7,1);
  end;
end;

procedure  TfrmMain.LEDOff(anLED:Integer);
begin
  case anLED of
    0 : gpioWrite(LED0,0);
    1 : gpioWrite(LED1,0);
    2 : gpioWrite(LED2,0);
    3 : gpioWrite(LED3,0);
    4 : gpioWrite(LED4,0);
    5 : gpioWrite(LED5,0);
    6 : gpioWrite(LED6,0);
    7 : gpioWrite(LED7,0);
  end;
end;

procedure TfrmMain.tmrControlTimer(Sender: TObject);
var
  i:integer;
begin
  if tglbtnIndividual.State = cbChecked then exit;
  if tglbtnUpDown.Checked then begin

      LEDOff(FLEDPosition);
      if FLEDDirection = ledUp then begin
        inc(FLEDPosition);
        if FLEDPosition = 7 then FLEDDirection := ledDown;
      end else begin
        dec(FLEDPosition);
        if FLEDPosition = 0 then FLEDDirection := ledUp;
      end;
      LEDOn(FLEDPosition);

  end else
  if tglbtnCylon.Checked then begin

      if FLEDDirection = ledUp then begin
        inc(FLEDPosition);
        i := FLEDPosition-3;
        if FLEDPosition = 9 then FLEDDirection := ledDown;
      end else begin
        dec(FLEDPosition);
        i := FLEDPosition+3;
        if FLEDPosition = -2 then FLEDDirection := ledUp;
      end;
      LEDOn(FLEDPosition);
      if (i >= 0) and (i <= 7) Then LEDOff(i);

  end else
  if tglbtnVUMeter.Checked then begin
     AllLEDsOff;
     FLEDPosition := Random(7);
     for i := 0 to FLEDPosition do
       LEDon(i);
  end;
end;

procedure TfrmMain.chkbxLED0Click(Sender: TObject);
begin
  if chkbxLED0.Checked
    then LEDOn(0)
    else LEDOff(0);
end;

procedure TfrmMain.chkbxLED1Click(Sender: TObject);
begin
  if chkbxLED1.Checked
    then LEDOn(1)
    else LEDOff(1);
end;

procedure TfrmMain.chkbxLED2Click(Sender: TObject);
begin
  if chkbxLED2.Checked
    then LEDOn(2)
    else LEDOff(2);
end;

procedure TfrmMain.chkbxLED3Click(Sender: TObject);
begin
  if chkbxLED3.Checked
    then LEDOn(3)
    else LEDOff(3);
end;

procedure TfrmMain.chkbxLED4Click(Sender: TObject);
begin
  if chkbxLED4.Checked
    then LEDOn(4)
    else LEDOff(4);
end;

procedure TfrmMain.chkbxLED5Click(Sender: TObject);
begin
  if chkbxLED5.Checked
    then LEDOn(5)
    else LEDOff(5);
end;

procedure TfrmMain.chkbxLED6Click(Sender: TObject);
begin
  if chkbxLED6.Checked
    then LEDOn(6)
    else LEDOff(6);
end;

procedure TfrmMain.chkbxLED7Click(Sender: TObject);
begin
  if chkbxLED7.Checked
    then LEDOn(7)
    else LEDOff(7);
end;

procedure TfrmMain.chkbxClearAll;
begin
  chkbxLED0.Checked:=False;
  chkbxLED1.Checked:=False;
  chkbxLED2.Checked:=False;
  chkbxLED3.Checked:=False;
  chkbxLED4.Checked:=False;
  chkbxLED5.Checked:=False;
  chkbxLED6.Checked:=False;
  chkbxLED7.Checked:=False;
end;

procedure TfrmMain.chkbxSetAll;
begin
  chkbxLED0.Checked:=true;
  chkbxLED1.Checked:=true;
  chkbxLED2.Checked:=true;
  chkbxLED3.Checked:=true;
  chkbxLED4.Checked:=true;
  chkbxLED5.Checked:=true;
  chkbxLED6.Checked:=true;
  chkbxLED7.Checked:=true;
end;

procedure TfrmMain.AllLEDsOn;
var i:integer;
begin
  for i := 0 to 7 do begin
    LEDOn(i);
  end;
end;

procedure TfrmMain.AllLEDsOff;
var i:integer;
begin
  for i := 0 to 7 do
    LEDOff(i);
end;

procedure TfrmMain.chkbxLEDAllClick(Sender: TObject);
var i:integer;
begin
  if chkbxLEDAll.Checked then begin
    AllLEDsOn;
    chkbxSetAll;
  end else begin
    AllLEDsOff;
    chkbxClearall;
  end;
end;

procedure TfrmMain.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  AllLEDsOff;
  gpioTerminate;
end;

end.

