/// <exclude />
  (* This unit was generated using the script genTaurusTLSHdrs.sh from the source file TaurusTLSHeaders_tls1.h2pas
     It should not be modified directly. All changes should be made to TaurusTLSHeaders_tls1.h2pas
     and this file regenerated. TaurusTLSHeaders_tls1.h2pas is distributed with the full Indy
     Distribution.
   *)
   
{$I TaurusTLSCompilerDefines.inc} 
{$I TaurusTLSLinkDefines.inc} 
{$IFNDEF USE_OPENSSL}
  { error Should not compile if USE_OPENSSL is not defined!!!}
{$ENDIF}
{******************************************************************************}
{*  TaurusTLS                                                                 *}
{*           https://github.com/JPeterMugaas/TaurusTLS                        *}
{*                                                                            *}
{*  Copyright (c) 2024 TaurusTLS Developers, All Rights Reserved              *}
{*                                                                            *}
{* Portions of this software are Copyright (c) 1993  2018,                   *}
{* Chad Z. Hower (Kudzu) and the Indy Pit Crew  http://www.IndyProject.org/  *}
{******************************************************************************}
unit TaurusTLSHeaders_tls1;

interface

// Headers for OpenSSL 1.1.1
// tls1.h


uses
  IdCTypes,
  IdGlobal,
  {$IFDEF OPENSSL_STATIC_LINK_MODEL}
  TaurusTLSConsts,
  {$ENDIF}
  TaurusTLSHeaders_types;

const
  (* Default security level if not overridden at config time *)
  OPENSSL_TLS_SECURITY_LEVEL = 1;

  TLS1_VERSION = $0301;
  TLS1_1_VERSION = $0302;
  TLS1_2_VERSION = $0303;
  TLS1_3_VERSION = $0304;
  DTLS1_VERSION = $FEFF;
  DTLS1_2_VERSION = $FEFD;
  DTLS1_BAD_VER = $0100;

///* QUIC uses a 4 byte unsigned version number */
  OSSL_QUIC1_VERSION = $0000001;

  (* Special value for method supporting multiple versions *)
  TLS_ANY_VERSION = $10000;

  TLS1_VERSION_MAJOR = $03;
  TLS1_VERSION_MINOR = $01;

  TLS1_1_VERSION_MAJOR = $03;
  TLS1_1_VERSION_MINOR = $02;

  TLS1_2_VERSION_MAJOR = $03;
  TLS1_2_VERSION_MINOR = $03;


//# define TLS1_get_version(s) \
//        ((SSL_version(s) >> 8) == TLS1_VERSION_MAJOR ? SSL_version(s) : 0)
//
//# define TLS1_get_client_version(s) \
//        ((SSL_client_version(s) >> 8) == TLS1_VERSION_MAJOR ? SSL_client_version(s) : 0)

  TLS1_AD_DECRYPTION_FAILED = 21;
  TLS1_AD_RECORD_OVERFLOW = 22;
  TLS1_AD_UNKNOWN_CA = 48; (* fatal *)
  TLS1_AD_ACCESS_DENIED = 49; (* fatal *)
  TLS1_AD_DECODE_ERROR = 50; (* fatal *)
  TLS1_AD_DECRYPT_ERROR = 51;
  TLS1_AD_EXPORT_RESTRICTION = 60; (* fatal *)
  TLS1_AD_PROTOCOL_VERSION = 70; (* fatal *)
  TLS1_AD_INSUFFICIENT_SECURITY = 71; (* fatal *)
  TLS1_AD_INTERNAL_ERROR = 80; (* fatal *)
  TLS1_AD_INAPPROPRIATE_FALLBACK = 86; (* fatal *)
  TLS1_AD_USER_CANCELLED = 90;
  TLS1_AD_NO_RENEGOTIATION = 100;
  (* TLSv1.3 alerts *)
  TLS13_AD_MISSING_EXTENSION = 109; (* fatal *)
  TLS13_AD_CERTIFICATE_REQUIRED = 116; (* fatal *)
  (* codes 110-114 are from RFC3546 *)
  TLS1_AD_UNSUPPORTED_EXTENSION = 110;
  TLS1_AD_CERTIFICATE_UNOBTAINABLE = 111;
  TLS1_AD_UNRECOGNIZED_NAME = 112;
  TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE = 113;
  TLS1_AD_BAD_CERTIFICATE_HASH_VALUE = 114;
  TLS1_AD_UNKNOWN_PSK_IDENTITY = 115; (* fatal *)
  TLS1_AD_NO_APPLICATION_PROTOCOL = 120; (* fatal *)

  (* ExtensionType values from RFC3546 / RFC4366 / RFC6066 *)
  TLSEXT_TYPE_server_name = 0;
  TLSEXT_TYPE_max_fragment_length = 1;
  TLSEXT_TYPE_client_certificate_url = 2;
  TLSEXT_TYPE_trusted_ca_keys = 3;
  TLSEXT_TYPE_truncated_hmac = 4;
  TLSEXT_TYPE_status_request = 5;
  (* ExtensionType values from RFC4681 *)
  TLSEXT_TYPE_user_mapping = 6;
  (* ExtensionType values from RFC5878 *)
  TLSEXT_TYPE_client_authz = 7;
  TLSEXT_TYPE_server_authz = 8;
  (* ExtensionType values from RFC6091 *)
  TLSEXT_TYPE_cert_type = 9;

  (* ExtensionType values from RFC4492 *)
  (*
   * Prior to TLSv1.3 the supported_groups extension was known as
   * elliptic_curves
   *)
  TLSEXT_TYPE_supported_groups = 10;
  TLSEXT_TYPE_elliptic_curves = TLSEXT_TYPE_supported_groups;
  TLSEXT_TYPE_ec_poTIdC_INT_formats = 11;

  (* ExtensionType value from RFC5054 *)
  TLSEXT_TYPE_srp = 12;
  (* ExtensionType values from RFC5246 *)
  TLSEXT_TYPE_signature_algorithms = 13;

  (* ExtensionType value from RFC5764 *)
  TLSEXT_TYPE_use_srtp = 14;

  (* ExtensionType value from RFC5620 *)
  TLSEXT_TYPE_heartbeat = 15;

  (* ExtensionType value from RFC7301 *)
  TLSEXT_TYPE_application_layer_protocol_negotiation = 16;

  (*
   * Extension type for Certificate Transparency
   * https://tools.ietf.org/html/rfc6962#section-3.3.1
   *)
  TLSEXT_TYPE_signed_certificate_timestamp = 18;

  (*
   * ExtensionType value for TLS padding extension.
   * http://tools.ietf.org/html/draft-agl-tls-padding
   *)
  TLSEXT_TYPE_padding = 21;

  (* ExtensionType value from RFC7366 *)
  TLSEXT_TYPE_encrypt_then_mac = 22;

  (* ExtensionType value from RFC7627 *)
  TLSEXT_TYPE_extended_master_secret = 23;

  (* ExtensionType value from RFC4507 *)
  TLSEXT_TYPE_session_ticket = 35;

  (* As defined for TLS1.3 *)
  TLSEXT_TYPE_psk = 41;
  TLSEXT_TYPE_early_data = 42;
  TLSEXT_TYPE_supported_versions = 43;
  TLSEXT_TYPE_cookie = 44;
  TLSEXT_TYPE_psk_kex_modes = 45;
  TLSEXT_TYPE_certificate_authorities = 47;
  TLSEXT_TYPE_post_handshake_auth = 49;
  TLSEXT_TYPE_signature_algorithms_cert = 50;
  TLSEXT_TYPE_key_share = 51;

  (* Temporary extension type *)
  TLSEXT_TYPE_renegotiate = $ff01;

  (* This is not an IANA defined extension number *)
  TLSEXT_TYPE_next_proto_neg = 13172;

  (* NameType value from RFC3546 *)
  TLSEXT_NAMETYPE_host_name = 0;
  (* status request value from RFC3546 *)
  TLSEXT_STATUSTYPE_ocsp = 1;

  (* ECPoTIdC_INTFormat values from RFC4492 *)
  TLSEXT_ECPOTIdC_INTFORMAT_first = 0;
  TLSEXT_ECPOTIdC_INTFORMAT_uncompressed = 0;
  TLSEXT_ECPOTIdC_INTFORMAT_ansiX962_compressed_prime = 1;
  TLSEXT_ECPOTIdC_INTFORMAT_ansiX962_compressed_PIdAnsiChar2 = 2;
  TLSEXT_ECPOTIdC_INTFORMAT_last = 2;

  (* Signature and hash algorithms from RFC5246 *)
  TLSEXT_signature_anonymous = 0;
  TLSEXT_signature_rsa = 1;
  TLSEXT_signature_dsa = 2;
  TLSEXT_signature_ecdsa = 3;
  TLSEXT_signature_gostr34102001 = 237;
  TLSEXT_signature_gostr34102012_256 = 238;
  TLSEXT_signature_gostr34102012_512 = 239;

  (* Total number of different signature algorithms *)
  TLSEXT_signature_num = 7;

  TLSEXT_hash_none = 0;
  TLSEXT_hash_md5 = 1;
  TLSEXT_hash_sha1 = 2;
  TLSEXT_hash_sha224 = 3;
  TLSEXT_hash_sha256 = 4;
  TLSEXT_hash_sha384 = 5;
  TLSEXT_hash_sha512 = 6;
  TLSEXT_hash_gostr3411 = 237;
  TLSEXT_hash_gostr34112012_256 = 238;
  TLSEXT_hash_gostr34112012_512 = 239;

  (* Total number of different digest algorithms *)
  TLSEXT_hash_num = 10;

  (* Flag set for unrecognised algorithms *)
  TLSEXT_nid_unknown = $1000000;

  (* ECC curves *)
  TLSEXT_curve_P_256 = 23;
  TLSEXT_curve_P_384 = 24;

  (* TaurusTLS value to disable maximum fragment length extension *)
  TLSEXT_max_fragment_length_DISABLED = 0;
  (* Allowed values for max fragment length extension *)
  TLSEXT_max_fragment_length_512 = 1;
  TLSEXT_max_fragment_length_1024 = 2;
  TLSEXT_max_fragment_length_2048 = 3;
  TLSEXT_max_fragment_length_4096 = 4;

  TLSEXT_MAXLEN_host_name = 255;

  SSL_TLSEXT_ERR_OK = 0;
  SSL_TLSEXT_ERR_ALERT_WARNING = 1;
  SSL_TLSEXT_ERR_ALERT_FATAL = 2;
  SSL_TLSEXT_ERR_NOACK = 3;

  SSL_DTLSEXT_HB_ENABLED = $01;
  SSL_DTLSEXT_HB_DONT_SEND_REQUESTS = $02;
  SSL_DTLSEXT_HB_DONT_RECV_REQUESTS = $04;

  (* PSK ciphersuites from 4279 *)
  TLS1_CK_PSK_WITH_RC4_128_SHA = $0300008A;
  TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA = $0300008B;
  TLS1_CK_PSK_WITH_AES_128_CBC_SHA = $0300008C;
  TLS1_CK_PSK_WITH_AES_256_CBC_SHA = $0300008D;
  TLS1_CK_DHE_PSK_WITH_RC4_128_SHA = $0300008E;
  TLS1_CK_DHE_PSK_WITH_3DES_EDE_CBC_SHA = $0300008F;
  TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA = $03000090;
  TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA = $03000091;
  TLS1_CK_RSA_PSK_WITH_RC4_128_SHA = $03000092;
  TLS1_CK_RSA_PSK_WITH_3DES_EDE_CBC_SHA = $03000093;
  TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA = $03000094;
  TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA = $03000095;

  (* PSK ciphersuites from 5487 *)
  TLS1_CK_PSK_WITH_AES_128_GCM_SHA256 = $030000A8;
  TLS1_CK_PSK_WITH_AES_256_GCM_SHA384 = $030000A9;
  TLS1_CK_DHE_PSK_WITH_AES_128_GCM_SHA256 = $030000AA;
  TLS1_CK_DHE_PSK_WITH_AES_256_GCM_SHA384 = $030000AB;
  TLS1_CK_RSA_PSK_WITH_AES_128_GCM_SHA256 = $030000AC;
  TLS1_CK_RSA_PSK_WITH_AES_256_GCM_SHA384 = $030000AD;
  TLS1_CK_PSK_WITH_AES_128_CBC_SHA256 = $030000AE;
  TLS1_CK_PSK_WITH_AES_256_CBC_SHA384 = $030000AF;
  TLS1_CK_PSK_WITH_NULL_SHA256 = $030000B0;
  TLS1_CK_PSK_WITH_NULL_SHA384 = $030000B1;
  TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA256 = $030000B2;
  TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA384 = $030000B3;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA256 = $030000B4;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA384 = $030000B5;
  TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA256 = $030000B6;
  TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA384 = $030000B7;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA256 = $030000B8;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA384 = $030000B9;

  (* NULL PSK ciphersuites from RFC4785 *)
  TLS1_CK_PSK_WITH_NULL_SHA = $0300002C;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA = $0300002D;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA = $0300002E;

  (* AES ciphersuites from RFC3268 *)
  TLS1_CK_RSA_WITH_AES_128_SHA = $0300002F;
  TLS1_CK_DH_DSS_WITH_AES_128_SHA = $03000030;
  TLS1_CK_DH_RSA_WITH_AES_128_SHA = $03000031;
  TLS1_CK_DHE_DSS_WITH_AES_128_SHA = $03000032;
  TLS1_CK_DHE_RSA_WITH_AES_128_SHA = $03000033;
  TLS1_CK_ADH_WITH_AES_128_SHA = $03000034;
  TLS1_CK_RSA_WITH_AES_256_SHA = $03000035;
  TLS1_CK_DH_DSS_WITH_AES_256_SHA = $03000036;
  TLS1_CK_DH_RSA_WITH_AES_256_SHA = $03000037;
  TLS1_CK_DHE_DSS_WITH_AES_256_SHA = $03000038;
  TLS1_CK_DHE_RSA_WITH_AES_256_SHA = $03000039;
  TLS1_CK_ADH_WITH_AES_256_SHA = $0300003A;

  (* TLS v1.2 ciphersuites *)
  TLS1_CK_RSA_WITH_NULL_SHA256 = $0300003B;
  TLS1_CK_RSA_WITH_AES_128_SHA256 = $0300003C;
  TLS1_CK_RSA_WITH_AES_256_SHA256 = $0300003D;
  TLS1_CK_DH_DSS_WITH_AES_128_SHA256 = $0300003E;
  TLS1_CK_DH_RSA_WITH_AES_128_SHA256 = $0300003F;
  TLS1_CK_DHE_DSS_WITH_AES_128_SHA256 = $03000040;

  (* Camellia ciphersuites from RFC4132 *)
  TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000041;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = $03000042;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000043;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = $03000044;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000045;
  TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA = $03000046;

  (* TLS v1.2 ciphersuites *)
  TLS1_CK_DHE_RSA_WITH_AES_128_SHA256 = $03000067;
  TLS1_CK_DH_DSS_WITH_AES_256_SHA256 = $03000068;
  TLS1_CK_DH_RSA_WITH_AES_256_SHA256 = $03000069;
  TLS1_CK_DHE_DSS_WITH_AES_256_SHA256 = $0300006A;
  TLS1_CK_DHE_RSA_WITH_AES_256_SHA256 = $0300006B;
  TLS1_CK_ADH_WITH_AES_128_SHA256 = $0300006C;
  TLS1_CK_ADH_WITH_AES_256_SHA256 = $0300006D;

  (* Camellia ciphersuites from RFC4132 *)
  TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000084;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = $03000085;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000086;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = $03000087;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000088;
  TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA = $03000089;

  (* SEED ciphersuites from RFC4162 *)
  TLS1_CK_RSA_WITH_SEED_SHA = $03000096;
  TLS1_CK_DH_DSS_WITH_SEED_SHA = $03000097;
  TLS1_CK_DH_RSA_WITH_SEED_SHA = $03000098;
  TLS1_CK_DHE_DSS_WITH_SEED_SHA = $03000099;
  TLS1_CK_DHE_RSA_WITH_SEED_SHA = $0300009A;
  TLS1_CK_ADH_WITH_SEED_SHA = $0300009B;

  (* TLS v1.2 GCM ciphersuites from RFC5288 *)
  TLS1_CK_RSA_WITH_AES_128_GCM_SHA256 = $0300009C;
  TLS1_CK_RSA_WITH_AES_256_GCM_SHA384 = $0300009D;
  TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256 = $0300009E;
  TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384 = $0300009F;
  TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256 = $030000A0;
  TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384 = $030000A1;
  TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256 = $030000A2;
  TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384 = $030000A3;
  TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256 = $030000A4;
  TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384 = $030000A5;
  TLS1_CK_ADH_WITH_AES_128_GCM_SHA256 = $030000A6;
  TLS1_CK_ADH_WITH_AES_256_GCM_SHA384 = $030000A7;

  (* CCM ciphersuites from RFC6655 *)
  TLS1_CK_RSA_WITH_AES_128_CCM = $0300C09C;
  TLS1_CK_RSA_WITH_AES_256_CCM = $0300C09D;
  TLS1_CK_DHE_RSA_WITH_AES_128_CCM = $0300C09E;
  TLS1_CK_DHE_RSA_WITH_AES_256_CCM = $0300C09F;
  TLS1_CK_RSA_WITH_AES_128_CCM_8 = $0300C0A0;
  TLS1_CK_RSA_WITH_AES_256_CCM_8 = $0300C0A1;
  TLS1_CK_DHE_RSA_WITH_AES_128_CCM_8 = $0300C0A2;
  TLS1_CK_DHE_RSA_WITH_AES_256_CCM_8 = $0300C0A3;
  TLS1_CK_PSK_WITH_AES_128_CCM = $0300C0A4;
  TLS1_CK_PSK_WITH_AES_256_CCM = $0300C0A5;
  TLS1_CK_DHE_PSK_WITH_AES_128_CCM = $0300C0A6;
  TLS1_CK_DHE_PSK_WITH_AES_256_CCM = $0300C0A7;
  TLS1_CK_PSK_WITH_AES_128_CCM_8 = $0300C0A8;
  TLS1_CK_PSK_WITH_AES_256_CCM_8 = $0300C0A9;
  TLS1_CK_DHE_PSK_WITH_AES_128_CCM_8 = $0300C0AA;
  TLS1_CK_DHE_PSK_WITH_AES_256_CCM_8 = $0300C0AB;

  (* CCM ciphersuites from RFC7251 *)
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM = $0300C0AC;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM = $0300C0AD;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM_8 = $0300C0AE;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM_8 = $0300C0AF;

  (* TLS 1.2 Camellia SHA-256 ciphersuites from RFC5932 *)
  TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BA;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = $030000BB;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BC;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = $030000BD;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BE;
  TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA256 = $030000BF;

  TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C0;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = $030000C1;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C2;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = $030000C3;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C4;
  TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA256 = $030000C5;

  (* ECC ciphersuites from RFC4492 *)
  TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA = $0300C001;
  TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA = $0300C002;
  TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA = $0300C003;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA = $0300C004;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA = $0300C005;

  TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA = $0300C006;
  TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA = $0300C007;
  TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = $0300C008;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = $0300C009;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = $0300C00A;

  TLS1_CK_ECDH_RSA_WITH_NULL_SHA = $0300C00B;
  TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA = $0300C00C;
  TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA = $0300C00D;
  TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA = $0300C00E;
  TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA = $0300C00F;

  TLS1_CK_ECDHE_RSA_WITH_NULL_SHA = $0300C010;
  TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA = $0300C011;
  TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA = $0300C012;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA = $0300C013;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA = $0300C014;

  TLS1_CK_ECDH_anon_WITH_NULL_SHA = $0300C015;
  TLS1_CK_ECDH_anon_WITH_RC4_128_SHA = $0300C016;
  TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA = $0300C017;
  TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA = $0300C018;
  TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA = $0300C019;

  (* SRP ciphersuites from RFC 5054 *)
  TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA = $0300C01A;
  TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = $0300C01B;
  TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = $0300C01C;
  TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA = $0300C01D;
  TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = $0300C01E;
  TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = $0300C01F;
  TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA = $0300C020;
  TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = $0300C021;
  TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = $0300C022;

  (* ECDH HMAC based ciphersuites from RFC5289 *)
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256 = $0300C023;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384 = $0300C024;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256 = $0300C025;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384 = $0300C026;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256 = $0300C027;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384 = $0300C028;
  TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256 = $0300C029;
  TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384 = $0300C02A;

  (* ECDH GCM based ciphersuites from RFC5289 *)
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = $0300C02B;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = $0300C02C;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = $0300C02D;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = $0300C02E;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = $0300C02F;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = $0300C030;
  TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256 = $0300C031;
  TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384 = $0300C032;

  (* ECDHE PSK ciphersuites from RFC5489 *)
  TLS1_CK_ECDHE_PSK_WITH_RC4_128_SHA = $0300C033;
  TLS1_CK_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = $0300C034;
  TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA = $0300C035;
  TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA = $0300C036;
  TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = $0300C037;
  TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = $0300C038;
  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA = $0300C039;

  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA256 = $0300C03A;
  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA384 = $0300C03B;

  (* Camellia-CBC ciphersuites from RFC6367 *)
  TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C072;
  TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C073;
  TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C074;
  TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C075;
  TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C076;
  TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C077;
  TLS1_CK_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C078;
  TLS1_CK_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C079;

  TLS1_CK_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C094;
  TLS1_CK_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C095;
  TLS1_CK_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C096;
  TLS1_CK_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C097;
  TLS1_CK_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C098;
  TLS1_CK_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C099;
  TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C09A;
  TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C09B;

  (* draft-ietf-tls-chacha20-poly1305-03 *)
  TLS1_CK_ECDHE_RSA_WITH_CHACHA20_POLY1305 = $0300CCA8;
  TLS1_CK_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = $0300CCA9;
  TLS1_CK_DHE_RSA_WITH_CHACHA20_POLY1305 = $0300CCAA;
  TLS1_CK_PSK_WITH_CHACHA20_POLY1305 = $0300CCAB;
  TLS1_CK_ECDHE_PSK_WITH_CHACHA20_POLY1305 = $0300CCAC;
  TLS1_CK_DHE_PSK_WITH_CHACHA20_POLY1305 = $0300CCAD;
  TLS1_CK_RSA_PSK_WITH_CHACHA20_POLY1305 = $0300CCAE;

  (* TLS v1.3 ciphersuites *)
  TLS1_3_CK_AES_128_GCM_SHA256 = $03001301;
  TLS1_3_CK_AES_256_GCM_SHA384 = $03001302;
  TLS1_3_CK_CHACHA20_POLY1305_SHA256 = $03001303;
  TLS1_3_CK_AES_128_CCM_SHA256 = $03001304;
  TLS1_3_CK_AES_128_CCM_8_SHA256 = $03001305;

  (* Aria ciphersuites from RFC6209 *)
  TLS1_CK_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C050;
  TLS1_CK_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C051;
  TLS1_CK_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C052;
  TLS1_CK_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C053;
  TLS1_CK_DH_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C054;
  TLS1_CK_DH_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C055;
  TLS1_CK_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = $0300C056;
  TLS1_CK_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = $0300C057;
  TLS1_CK_DH_DSS_WITH_ARIA_128_GCM_SHA256 = $0300C058;
  TLS1_CK_DH_DSS_WITH_ARIA_256_GCM_SHA384 = $0300C059;
  TLS1_CK_DH_anon_WITH_ARIA_128_GCM_SHA256 = $0300C05A;
  TLS1_CK_DH_anon_WITH_ARIA_256_GCM_SHA384 = $0300C05B;
  TLS1_CK_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = $0300C05C;
  TLS1_CK_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = $0300C05D;
  TLS1_CK_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = $0300C05E;
  TLS1_CK_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = $0300C05F;
  TLS1_CK_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C060;
  TLS1_CK_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C061;
  TLS1_CK_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C062;
  TLS1_CK_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C063;
  TLS1_CK_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06A;
  TLS1_CK_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06B;
  TLS1_CK_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06C;
  TLS1_CK_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06D;
  TLS1_CK_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06E;
  TLS1_CK_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06F;

  (* a bundle of RFC standard cipher names, generated from ssl3_ciphers[] *)
  TLS1_RFC_RSA_WITH_AES_128_SHA = 'TLS_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_AES_128_SHA = 'TLS_DHE_DSS_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_AES_128_SHA = 'TLS_DHE_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ADH_WITH_AES_128_SHA = 'TLS_DH_anon_WITH_AES_128_CBC_SHA';
  TLS1_RFC_RSA_WITH_AES_256_SHA = 'TLS_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_AES_256_SHA = 'TLS_DHE_DSS_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_AES_256_SHA = 'TLS_DHE_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ADH_WITH_AES_256_SHA = 'TLS_DH_anon_WITH_AES_256_CBC_SHA';
  TLS1_RFC_RSA_WITH_NULL_SHA256 = 'TLS_RSA_WITH_NULL_SHA256';
  TLS1_RFC_RSA_WITH_AES_128_SHA256 = 'TLS_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_RSA_WITH_AES_256_SHA256 = 'TLS_RSA_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_128_SHA256 = 'TLS_DHE_DSS_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_128_SHA256 = 'TLS_DHE_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_256_SHA256 = 'TLS_DHE_DSS_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_256_SHA256 = 'TLS_DHE_RSA_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_ADH_WITH_AES_128_SHA256 = 'TLS_DH_anon_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ADH_WITH_AES_256_SHA256 = 'TLS_DH_anon_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_DSS_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_DSS_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_DSS_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_ADH_WITH_AES_128_GCM_SHA256 = 'TLS_DH_anon_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ADH_WITH_AES_256_GCM_SHA384 = 'TLS_DH_anon_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_RSA_WITH_AES_128_CCM = 'TLS_RSA_WITH_AES_128_CCM';
  TLS1_RFC_RSA_WITH_AES_256_CCM = 'TLS_RSA_WITH_AES_256_CCM';
  TLS1_RFC_DHE_RSA_WITH_AES_128_CCM = 'TLS_DHE_RSA_WITH_AES_128_CCM';
  TLS1_RFC_DHE_RSA_WITH_AES_256_CCM = 'TLS_DHE_RSA_WITH_AES_256_CCM';
  TLS1_RFC_RSA_WITH_AES_128_CCM_8 = 'TLS_RSA_WITH_AES_128_CCM_8';
  TLS1_RFC_RSA_WITH_AES_256_CCM_8 = 'TLS_RSA_WITH_AES_256_CCM_8';
  TLS1_RFC_DHE_RSA_WITH_AES_128_CCM_8 = 'TLS_DHE_RSA_WITH_AES_128_CCM_8';
  TLS1_RFC_DHE_RSA_WITH_AES_256_CCM_8 = 'TLS_DHE_RSA_WITH_AES_256_CCM_8';
  TLS1_RFC_PSK_WITH_AES_128_CCM = 'TLS_PSK_WITH_AES_128_CCM';
  TLS1_RFC_PSK_WITH_AES_256_CCM = 'TLS_PSK_WITH_AES_256_CCM';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CCM = 'TLS_DHE_PSK_WITH_AES_128_CCM';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CCM = 'TLS_DHE_PSK_WITH_AES_256_CCM';
  TLS1_RFC_PSK_WITH_AES_128_CCM_8 = 'TLS_PSK_WITH_AES_128_CCM_8';
  TLS1_RFC_PSK_WITH_AES_256_CCM_8 = 'TLS_PSK_WITH_AES_256_CCM_8';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CCM_8 = 'TLS_PSK_DHE_WITH_AES_128_CCM_8';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CCM_8 = 'TLS_PSK_DHE_WITH_AES_256_CCM_8';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM = 'TLS_ECDHE_ECDSA_WITH_AES_128_CCM';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM = 'TLS_ECDHE_ECDSA_WITH_AES_256_CCM';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 'TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 'TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8';
  TLS1_3_RFC_AES_128_GCM_SHA256 = 'TLS_AES_128_GCM_SHA256';
  TLS1_3_RFC_AES_256_GCM_SHA384 = 'TLS_AES_256_GCM_SHA384';
  TLS1_3_RFC_CHACHA20_POLY1305_SHA256 = 'TLS_CHACHA20_POLY1305_SHA256';
  TLS1_3_RFC_AES_128_CCM_SHA256 = 'TLS_AES_128_CCM_SHA256';
  TLS1_3_RFC_AES_128_CCM_8_SHA256 = 'TLS_AES_128_CCM_8_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_NULL_SHA = 'TLS_ECDHE_ECDSA_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = 'TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_NULL_SHA = 'TLS_ECDHE_RSA_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_DES_192_CBC3_SHA = 'TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_NULL_SHA = 'TLS_ECDH_anon_WITH_NULL_SHA';
  TLS1_RFC_ECDH_anon_WITH_DES_192_CBC3_SHA = 'TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_AES_128_CBC_SHA = 'TLS_ECDH_anon_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_AES_256_CBC_SHA = 'TLS_ECDH_anon_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_SHA256 = 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_SHA384 = 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_SHA256 = 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_SHA384 = 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 'TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 'TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_NULL_SHA = 'TLS_PSK_WITH_NULL_SHA';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA = 'TLS_DHE_PSK_WITH_NULL_SHA';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA = 'TLS_RSA_PSK_WITH_NULL_SHA';
  TLS1_RFC_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_128_CBC_SHA = 'TLS_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_256_CBC_SHA = 'TLS_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA = 'TLS_DHE_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA = 'TLS_DHE_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA = 'TLS_RSA_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA = 'TLS_RSA_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_RSA_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_RSA_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_RSA_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_RSA_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_PSK_WITH_NULL_SHA256 = 'TLS_PSK_WITH_NULL_SHA256';
  TLS1_RFC_PSK_WITH_NULL_SHA384 = 'TLS_PSK_WITH_NULL_SHA384';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_DHE_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_DHE_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA256 = 'TLS_DHE_PSK_WITH_NULL_SHA256';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA384 = 'TLS_DHE_PSK_WITH_NULL_SHA384';
  TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_RSA_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_RSA_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA256 = 'TLS_RSA_PSK_WITH_NULL_SHA256';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA384 = 'TLS_RSA_PSK_WITH_NULL_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA = 'TLS_ECDHE_PSK_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA256 = 'TLS_ECDHE_PSK_WITH_NULL_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA384 = 'TLS_ECDHE_PSK_WITH_NULL_SHA384';
  TLS1_RFC_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CHACHA20_POLY1305 = 'TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_PSK_WITH_CHACHA20_POLY1305 = 'TLS_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_DHE_PSK_WITH_CHACHA20_POLY1305 = 'TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_RSA_PSK_WITH_CHACHA20_POLY1305 = 'TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA = 'TLS_RSA_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA = 'TLS_RSA_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_RSA_WITH_SEED_SHA = 'TLS_RSA_WITH_SEED_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_SEED_SHA = 'TLS_DHE_DSS_WITH_SEED_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_SEED_SHA = 'TLS_DHE_RSA_WITH_SEED_CBC_SHA';
  TLS1_RFC_ADH_WITH_SEED_SHA = 'TLS_DH_anon_WITH_SEED_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_RC4_128_SHA = 'TLS_ECDHE_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_ECDH_anon_WITH_RC4_128_SHA = 'TLS_ECDH_anon_WITH_RC4_128_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_RC4_128_SHA = 'TLS_ECDHE_ECDSA_WITH_RC4_128_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_RC4_128_SHA = 'TLS_ECDHE_RSA_WITH_RC4_128_SHA';
  TLS1_RFC_PSK_WITH_RC4_128_SHA = 'TLS_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_RSA_PSK_WITH_RC4_128_SHA = 'TLS_RSA_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_DHE_PSK_WITH_RC4_128_SHA = 'TLS_DHE_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_anon_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_anon_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_anon_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_anon_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_PSK_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384';

  (*
   * XXX Backward compatibility alert: Older versions of TaurusTLS gave some DHE
   * ciphers names with "EDH" instead of "DHE".  Going forward, we should be
   * using DHE everywhere, though we may indefinitely maTIdC_INTain aliases for
   * users or configurations that used "EDH"
   *)
  TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA = 'DHE-DSS-RC4-SHA';

  TLS1_TXT_PSK_WITH_NULL_SHA = 'PSK-NULL-SHA';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA = 'DHE-PSK-NULL-SHA';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA = 'RSA-PSK-NULL-SHA';

  (* AES ciphersuites from RFC3268 *)
  TLS1_TXT_RSA_WITH_AES_128_SHA = 'AES128-SHA';
  TLS1_TXT_DH_DSS_WITH_AES_128_SHA = 'DH-DSS-AES128-SHA';
  TLS1_TXT_DH_RSA_WITH_AES_128_SHA = 'DH-RSA-AES128-SHA';
  TLS1_TXT_DHE_DSS_WITH_AES_128_SHA = 'DHE-DSS-AES128-SHA';
  TLS1_TXT_DHE_RSA_WITH_AES_128_SHA = 'DHE-RSA-AES128-SHA';
  TLS1_TXT_ADH_WITH_AES_128_SHA = 'ADH-AES128-SHA';

  TLS1_TXT_RSA_WITH_AES_256_SHA = 'AES256-SHA';
  TLS1_TXT_DH_DSS_WITH_AES_256_SHA = 'DH-DSS-AES256-SHA';
  TLS1_TXT_DH_RSA_WITH_AES_256_SHA = 'DH-RSA-AES256-SHA';
  TLS1_TXT_DHE_DSS_WITH_AES_256_SHA = 'DHE-DSS-AES256-SHA';
  TLS1_TXT_DHE_RSA_WITH_AES_256_SHA = 'DHE-RSA-AES256-SHA';
  TLS1_TXT_ADH_WITH_AES_256_SHA = 'ADH-AES256-SHA';

  (* ECC ciphersuites from RFC4492 *)
  TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA = 'ECDH-ECDSA-NULL-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA = 'ECDH-ECDSA-RC4-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA = 'ECDH-ECDSA-DES-CBC3-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 'ECDH-ECDSA-AES128-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 'ECDH-ECDSA-AES256-SHA';

  TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA = 'ECDHE-ECDSA-NULL-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA = 'ECDHE-ECDSA-RC4-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = 'ECDHE-ECDSA-DES-CBC3-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 'ECDHE-ECDSA-AES128-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 'ECDHE-ECDSA-AES256-SHA';

  TLS1_TXT_ECDH_RSA_WITH_NULL_SHA = 'ECDH-RSA-NULL-SHA';
  TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA = 'ECDH-RSA-RC4-SHA';
  TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA = 'ECDH-RSA-DES-CBC3-SHA';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA = 'ECDH-RSA-AES128-SHA';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA = 'ECDH-RSA-AES256-SHA';

  TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA = 'ECDHE-RSA-NULL-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA = 'ECDHE-RSA-RC4-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA = 'ECDHE-RSA-DES-CBC3-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA = 'ECDHE-RSA-AES128-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA = 'ECDHE-RSA-AES256-SHA';

  TLS1_TXT_ECDH_anon_WITH_NULL_SHA = 'AECDH-NULL-SHA';
  TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA = 'AECDH-RC4-SHA';
  TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA = 'AECDH-DES-CBC3-SHA';
  TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA = 'AECDH-AES128-SHA';
  TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA = 'AECDH-AES256-SHA';

  (* PSK ciphersuites from RFC 4279 *)
  TLS1_TXT_PSK_WITH_RC4_128_SHA = 'PSK-RC4-SHA';
  TLS1_TXT_PSK_WITH_3DES_EDE_CBC_SHA = 'PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_PSK_WITH_AES_128_CBC_SHA = 'PSK-AES128-CBC-SHA';
  TLS1_TXT_PSK_WITH_AES_256_CBC_SHA = 'PSK-AES256-CBC-SHA';

  TLS1_TXT_DHE_PSK_WITH_RC4_128_SHA = 'DHE-PSK-RC4-SHA';
  TLS1_TXT_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 'DHE-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA = 'DHE-PSK-AES128-CBC-SHA';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA = 'DHE-PSK-AES256-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_RC4_128_SHA = 'RSA-PSK-RC4-SHA';
  TLS1_TXT_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 'RSA-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA = 'RSA-PSK-AES128-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA = 'RSA-PSK-AES256-CBC-SHA';

  (* PSK ciphersuites from RFC 5487 *)
  TLS1_TXT_PSK_WITH_AES_128_GCM_SHA256 = 'PSK-AES128-GCM-SHA256';
  TLS1_TXT_PSK_WITH_AES_256_GCM_SHA384 = 'PSK-AES256-GCM-SHA384';
  TLS1_TXT_DHE_PSK_WITH_AES_128_GCM_SHA256 = 'DHE-PSK-AES128-GCM-SHA256';
  TLS1_TXT_DHE_PSK_WITH_AES_256_GCM_SHA384 = 'DHE-PSK-AES256-GCM-SHA384';
  TLS1_TXT_RSA_PSK_WITH_AES_128_GCM_SHA256 = 'RSA-PSK-AES128-GCM-SHA256';
  TLS1_TXT_RSA_PSK_WITH_AES_256_GCM_SHA384 = 'RSA-PSK-AES256-GCM-SHA384';

  TLS1_TXT_PSK_WITH_AES_128_CBC_SHA256 = 'PSK-AES128-CBC-SHA256';
  TLS1_TXT_PSK_WITH_AES_256_CBC_SHA384 = 'PSK-AES256-CBC-SHA384';
  TLS1_TXT_PSK_WITH_NULL_SHA256 = 'PSK-NULL-SHA256';
  TLS1_TXT_PSK_WITH_NULL_SHA384 = 'PSK-NULL-SHA384';

  TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA256 = 'DHE-PSK-AES128-CBC-SHA256';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA384 = 'DHE-PSK-AES256-CBC-SHA384';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA256 = 'DHE-PSK-NULL-SHA256';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA384 = 'DHE-PSK-NULL-SHA384';

  TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA256 = 'RSA-PSK-AES128-CBC-SHA256';
  TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA384 = 'RSA-PSK-AES256-CBC-SHA384';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA256 = 'RSA-PSK-NULL-SHA256';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA384 = 'RSA-PSK-NULL-SHA384';

  (* SRP ciphersuite from RFC 5054 *)
  TLS1_TXT_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 'SRP-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 'SRP-RSA-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 'SRP-DSS-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_WITH_AES_128_CBC_SHA = 'SRP-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 'SRP-RSA-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 'SRP-DSS-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_WITH_AES_256_CBC_SHA = 'SRP-AES-256-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 'SRP-RSA-AES-256-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 'SRP-DSS-AES-256-CBC-SHA';

  (* Camellia ciphersuites from RFC4132 *)
  TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA = 'CAMELLIA128-SHA';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 'DH-DSS-CAMELLIA128-SHA';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 'DH-RSA-CAMELLIA128-SHA';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 'DHE-DSS-CAMELLIA128-SHA';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 'DHE-RSA-CAMELLIA128-SHA';
  TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA = 'ADH-CAMELLIA128-SHA';

  TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA = 'CAMELLIA256-SHA';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 'DH-DSS-CAMELLIA256-SHA';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 'DH-RSA-CAMELLIA256-SHA';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 'DHE-DSS-CAMELLIA256-SHA';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 'DHE-RSA-CAMELLIA256-SHA';
  TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA = 'ADH-CAMELLIA256-SHA';

  (* TLS 1.2 Camellia SHA-256 ciphersuites from RFC5932 *)
  TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'CAMELLIA128-SHA256';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'DH-DSS-CAMELLIA128-SHA256';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'DH-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-DSS-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA256 = 'ADH-CAMELLIA128-SHA256';

  TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'CAMELLIA256-SHA256';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'DH-DSS-CAMELLIA256-SHA256';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'DH-RSA-CAMELLIA256-SHA256';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'DHE-DSS-CAMELLIA256-SHA256';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'DHE-RSA-CAMELLIA256-SHA256';
  TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA256 = 'ADH-CAMELLIA256-SHA256';

  TLS1_TXT_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'PSK-CAMELLIA128-SHA256';
  TLS1_TXT_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'PSK-CAMELLIA256-SHA384';
  TLS1_TXT_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'DHE-PSK-CAMELLIA256-SHA384';
  TLS1_TXT_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'RSA-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'RSA-PSK-CAMELLIA256-SHA384';
  TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-PSK-CAMELLIA256-SHA384';

  (* SEED ciphersuites from RFC4162 *)
  TLS1_TXT_RSA_WITH_SEED_SHA = 'SEED-SHA';
  TLS1_TXT_DH_DSS_WITH_SEED_SHA = 'DH-DSS-SEED-SHA';
  TLS1_TXT_DH_RSA_WITH_SEED_SHA = 'DH-RSA-SEED-SHA';
  TLS1_TXT_DHE_DSS_WITH_SEED_SHA = 'DHE-DSS-SEED-SHA';
  TLS1_TXT_DHE_RSA_WITH_SEED_SHA = 'DHE-RSA-SEED-SHA';
  TLS1_TXT_ADH_WITH_SEED_SHA = 'ADH-SEED-SHA';

  (* TLS v1.2 ciphersuites *)
  TLS1_TXT_RSA_WITH_NULL_SHA256 = 'NULL-SHA256';
  TLS1_TXT_RSA_WITH_AES_128_SHA256 = 'AES128-SHA256';
  TLS1_TXT_RSA_WITH_AES_256_SHA256 = 'AES256-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_128_SHA256 = 'DH-DSS-AES128-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_128_SHA256 = 'DH-RSA-AES128-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256 = 'DHE-DSS-AES128-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256 = 'DHE-RSA-AES128-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_256_SHA256 = 'DH-DSS-AES256-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_256_SHA256 = 'DH-RSA-AES256-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256 = 'DHE-DSS-AES256-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256 = 'DHE-RSA-AES256-SHA256';
  TLS1_TXT_ADH_WITH_AES_128_SHA256 = 'ADH-AES128-SHA256';
  TLS1_TXT_ADH_WITH_AES_256_SHA256 = 'ADH-AES256-SHA256';

  (* TLS v1.2 GCM ciphersuites from RFC5288 *)
  TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256 = 'AES128-GCM-SHA256';
  TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384 = 'AES256-GCM-SHA384';
  TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256 = 'DHE-RSA-AES128-GCM-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384 = 'DHE-RSA-AES256-GCM-SHA384';
  TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256 = 'DH-RSA-AES128-GCM-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384 = 'DH-RSA-AES256-GCM-SHA384';
  TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256 = 'DHE-DSS-AES128-GCM-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384 = 'DHE-DSS-AES256-GCM-SHA384';
  TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256 = 'DH-DSS-AES128-GCM-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384 = 'DH-DSS-AES256-GCM-SHA384';
  TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256 = 'ADH-AES128-GCM-SHA256';
  TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384 = 'ADH-AES256-GCM-SHA384';

  (* CCM ciphersuites from RFC6655 *)
  TLS1_TXT_RSA_WITH_AES_128_CCM = 'AES128-CCM';
  TLS1_TXT_RSA_WITH_AES_256_CCM = 'AES256-CCM';
  TLS1_TXT_DHE_RSA_WITH_AES_128_CCM = 'DHE-RSA-AES128-CCM';
  TLS1_TXT_DHE_RSA_WITH_AES_256_CCM = 'DHE-RSA-AES256-CCM';

  TLS1_TXT_RSA_WITH_AES_128_CCM_8 = 'AES128-CCM8';
  TLS1_TXT_RSA_WITH_AES_256_CCM_8 = 'AES256-CCM8';
  TLS1_TXT_DHE_RSA_WITH_AES_128_CCM_8 = 'DHE-RSA-AES128-CCM8';
  TLS1_TXT_DHE_RSA_WITH_AES_256_CCM_8 = 'DHE-RSA-AES256-CCM8';

  TLS1_TXT_PSK_WITH_AES_128_CCM = 'PSK-AES128-CCM';
  TLS1_TXT_PSK_WITH_AES_256_CCM = 'PSK-AES256-CCM';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CCM = 'DHE-PSK-AES128-CCM';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CCM = 'DHE-PSK-AES256-CCM';

  TLS1_TXT_PSK_WITH_AES_128_CCM_8 = 'PSK-AES128-CCM8';
  TLS1_TXT_PSK_WITH_AES_256_CCM_8 = 'PSK-AES256-CCM8';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CCM_8 = 'DHE-PSK-AES128-CCM8';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CCM_8 = 'DHE-PSK-AES256-CCM8';

  (* CCM ciphersuites from RFC7251 *)
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM = 'ECDHE-ECDSA-AES128-CCM';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM = 'ECDHE-ECDSA-AES256-CCM';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 'ECDHE-ECDSA-AES128-CCM8';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 'ECDHE-ECDSA-AES256-CCM8';

  (* ECDH HMAC based ciphersuites from RFC5289 *)
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256 = 'ECDHE-ECDSA-AES128-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384 = 'ECDHE-ECDSA-AES256-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256 = 'ECDH-ECDSA-AES128-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384 = 'ECDH-ECDSA-AES256-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256 = 'ECDHE-RSA-AES128-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384 = 'ECDHE-RSA-AES256-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256 = 'ECDH-RSA-AES128-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384 = 'ECDH-RSA-AES256-SHA384';

  (* ECDH GCM based ciphersuites from RFC5289 *)
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 'ECDHE-ECDSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 'ECDHE-ECDSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 'ECDH-ECDSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = 'ECDH-ECDSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 'ECDHE-RSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 'ECDHE-RSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 'ECDH-RSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384 = 'ECDH-RSA-AES256-GCM-SHA384';

  (* TLS v1.2 PSK GCM ciphersuites from RFC5487 *)
  //TLS1_TXT_PSK_WITH_AES_128_GCM_SHA256 = 'PSK-AES128-GCM-SHA256';
  //TLS1_TXT_PSK_WITH_AES_256_GCM_SHA384 = 'PSK-AES256-GCM-SHA384';

  (* ECDHE PSK ciphersuites from RFC 5489 *)
  TLS1_TXT_ECDHE_PSK_WITH_RC4_128_SHA = 'ECDHE-PSK-RC4-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 'ECDHE-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA = 'ECDHE-PSK-AES128-CBC-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA = 'ECDHE-PSK-AES256-CBC-SHA';

  TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 'ECDHE-PSK-AES128-CBC-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 'ECDHE-PSK-AES256-CBC-SHA384';

  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA = 'ECDHE-PSK-NULL-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA256 = 'ECDHE-PSK-NULL-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA384 = 'ECDHE-PSK-NULL-SHA384';

  (* Camellia-CBC ciphersuites from RFC6367 *)
  TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-ECDSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-ECDSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDH-ECDSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDH-ECDSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-RSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDH-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDH-RSA-CAMELLIA256-SHA384';

  (* draft-ietf-tls-chacha20-poly1305-03 *)
  TLS1_TXT_ECDHE_RSA_WITH_CHACHA20_POLY1305 = 'ECDHE-RSA-CHACHA20-POLY1305';
  TLS1_TXT_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = 'ECDHE-ECDSA-CHACHA20-POLY1305';
  TLS1_TXT_DHE_RSA_WITH_CHACHA20_POLY1305 = 'DHE-RSA-CHACHA20-POLY1305';
  TLS1_TXT_PSK_WITH_CHACHA20_POLY1305 = 'PSK-CHACHA20-POLY1305';
  TLS1_TXT_ECDHE_PSK_WITH_CHACHA20_POLY1305 = 'ECDHE-PSK-CHACHA20-POLY1305';
  TLS1_TXT_DHE_PSK_WITH_CHACHA20_POLY1305 = 'DHE-PSK-CHACHA20-POLY1305';
  TLS1_TXT_RSA_PSK_WITH_CHACHA20_POLY1305 = 'RSA-PSK-CHACHA20-POLY1305';

  (* Aria ciphersuites from RFC6209 *)
  TLS1_TXT_RSA_WITH_ARIA_128_GCM_SHA256 = 'ARIA128-GCM-SHA256';
  TLS1_TXT_RSA_WITH_ARIA_256_GCM_SHA384 = 'ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'DHE-RSA-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'DHE-RSA-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 'DH-RSA-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 'DH-RSA-ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 'DHE-DSS-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 'DHE-DSS-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 'DH-DSS-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 'DH-DSS-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_anon_WITH_ARIA_128_GCM_SHA256 = 'ADH-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_anon_WITH_ARIA_256_GCM_SHA384 = 'ADH-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'ECDHE-ECDSA-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'ECDHE-ECDSA-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'ECDH-ECDSA-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'ECDH-ECDSA-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'ECDHE-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'ECDHE-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 'ECDH-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 'ECDH-ARIA256-GCM-SHA384';
  TLS1_TXT_PSK_WITH_ARIA_128_GCM_SHA256 = 'PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_PSK_WITH_ARIA_256_GCM_SHA384 = 'PSK-ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 'DHE-PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 'DHE-PSK-ARIA256-GCM-SHA384';
  TLS1_TXT_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 'RSA-PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 'RSA-PSK-ARIA256-GCM-SHA384';

  TLS_CT_RSA_SIGN = 1;
  TLS_CT_DSS_SIGN = 2;
  TLS_CT_RSA_FIXED_DH = 3;
  TLS_CT_DSS_FIXED_DH = 4;
  TLS_CT_ECDSA_SIGN = 64;
  TLS_CT_RSA_FIXED_ECDH = 65;
  TLS_CT_ECDSA_FIXED_ECDH = 66;
  TLS_CT_GOST01_SIGN = 22;
  TLS_CT_GOST12_SIGN = 238;
  TLS_CT_GOST12_512_SIGN = 239;

  (*
   * when correcting this number, correct also SSL3_CT_NUMBER in ssl3.h (see
   * comment there)
   *)
  TLS_CT_NUMBER = 10;

  TLS1_FINISH_MAC_LENGTH = 12;

  TLS_MD_MAX_CONST_SIZE = 22;
  TLS_MD_CLIENT_FINISH_CONST  = 'client finished';
  TLS_MD_CLIENT_FINISH_CONST_SIZE = 15;
  TLS_MD_SERVER_FINISH_CONST  = 'server finished';
  TLS_MD_SERVER_FINISH_CONST_SIZE = 15;
  TLS_MD_KEY_EXPANSION_CONST  = 'key expansion';
  TLS_MD_KEY_EXPANSION_CONST_SIZE = 13;
  TLS_MD_CLIENT_WRITE_KEY_CONST  = 'client write key';
  TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE = 16;
  TLS_MD_SERVER_WRITE_KEY_CONST  = 'server write key';
  TLS_MD_SERVER_WRITE_KEY_CONST_SIZE = 16;
  TLS_MD_IV_BLOCK_CONST  = 'IV block';
  TLS_MD_IV_BLOCK_CONST_SIZE = 8;
  TLS_MD_MASTER_SECRET_CONST  = 'master secret';
  TLS_MD_MASTER_SECRET_CONST_SIZE = 13;
  TLS_MD_EXTENDED_MASTER_SECRET_CONST  = 'extended master secret';
  TLS_MD_EXTENDED_MASTER_SECRET_CONST_SIZE = 22;

//  (*
//   * client finished
//   *)
//  TLS_MD_CLIENT_FINISH_CONST = TIdAnsiChar($63) + TIdAnsiChar($6c) + TIdAnsiChar($69) + TIdAnsiChar($65) + TIdAnsiChar($6e) + TIdAnsiChar($74) + TIdAnsiChar($20) + TIdAnsiChar($66) + TIdAnsiChar($69) + TIdAnsiChar($6e) + TIdAnsiChar($69) + TIdAnsiChar($73) + TIdAnsiChar($68) + TIdAnsiChar($65) + TIdAnsiChar($64);
//
//  (*
//   * server finished
//   *)
//  TLS_MD_SERVER_FINISH_CONST = TIdAnsiChar($73) + TIdAnsiChar($65) + TIdAnsiChar($72) + TIdAnsiChar($76) + TIdAnsiChar($65) + TIdAnsiChar($72) + TIdAnsiChar($20) + TIdAnsiChar($66) + TIdAnsiChar($69) + TIdAnsiChar($6e) + TIdAnsiChar($69) + TIdAnsiChar($73) + TIdAnsiChar($68) + TIdAnsiChar($65) + TIdAnsiChar($64);
//
//  (*
//   * server write key
//   *)
//  TLS_MD_SERVER_WRITE_KEY_CONST = TIdAnsiChar($73) + TIdAnsiChar($65) + TIdAnsiChar($72) + TIdAnsiChar($76) + TIdAnsiChar($65) + TIdAnsiChar($72) + TIdAnsiChar($20) + TIdAnsiChar($77) + TIdAnsiChar($72) + TIdAnsiChar($69) + TIdAnsiChar($74) + TIdAnsiChar($65) + TIdAnsiChar($20) + TIdAnsiChar($6b) + TIdAnsiChar($65) + TIdAnsiChar($79);
//
//  (*
//   * key expansion
//   *)
//  TLS_MD_KEY_EXPANSION_CONST = TIdAnsiChar($6b) + TIdAnsiChar($65) + TIdAnsiChar($79) + TIdAnsiChar($20) + TIdAnsiChar($65) + TIdAnsiChar($78) + TIdAnsiChar($70) + TIdAnsiChar($61) + TIdAnsiChar($6e) + TIdAnsiChar($73) + TIdAnsiChar($69) + TIdAnsiChar($6f) + TIdAnsiChar($6e);
//
//  (*
//   * client write key
//   *)
//  TLS_MD_CLIENT_WRITE_KEY_CONST = TIdAnsiChar($63) + TIdAnsiChar($6c) + TIdAnsiChar($69) + TIdAnsiChar($65) + TIdAnsiChar($6e) + TIdAnsiChar($74) + TIdAnsiChar($20) + TIdAnsiChar($77) + TIdAnsiChar($72) + TIdAnsiChar($69) + TIdAnsiChar($74) + TIdAnsiChar($65) + TIdAnsiChar($20) + TIdAnsiChar($6b) + TIdAnsiChar($65) + TIdAnsiChar($79);
//
//  (*
//   * server write key
//   *)
//  TLS_MD_SERVER_WRITE_KEY_CONST = TIdAnsiChar($73) + TIdAnsiChar($65) + TIdAnsiChar($72) + TIdAnsiChar($76) + TIdAnsiChar($65) + TIdAnsiChar($72) + TIdAnsiChar($20) + TIdAnsiChar($77) + TIdAnsiChar($72) + TIdAnsiChar($69) + TIdAnsiChar($74) + TIdAnsiChar($65) + TIdAnsiChar($20) + TIdAnsiChar($6b) + TIdAnsiChar($65) + TIdAnsiChar($79);
//
//  (*
//   * IV block
//   *)
//  TLS_MD_IV_BLOCK_CONST = TIdAnsiChar($49) + TIdAnsiChar($56) + TIdAnsiChar($20) + TIdAnsiChar($62) + TIdAnsiChar($6c) + TIdAnsiChar($6f) + TIdAnsiChar($63) + TIdAnsiChar($6b);
//
//  (*
//   * master secret
//   *)
//  TLS_MD_MASTER_SECRET_CONST = TIdAnsiChar($6d) + TIdAnsiChar($61) + TIdAnsiChar($73) + TIdAnsiChar($74) + TIdAnsiChar($65) + TIdAnsiChar($72) + TIdAnsiChar($20) + TIdAnsiChar($73) + TIdAnsiChar($65) + TIdAnsiChar($63) + TIdAnsiChar($72) + TIdAnsiChar($65) + TIdAnsiChar($74);
//
//  (*
//   * extended master secret
//   *)
//  TLS_MD_EXTENDED_MASTER_SECRET_CONST = TIdAnsiChar($65) + TIdAnsiChar($78) + TIdAnsiChar($74) + TIdAnsiChar($65) + TIdAnsiChar($6e) + TIdAnsiChar($64) + TIdAnsiChar($65) + TIdAnsiChar($64) + TIdAnsiChar($20) + TIdAnsiChar($6d) + TIdAnsiChar($61) + TIdAnsiChar($73) + TIdAnsiChar($74) + TIdAnsiChar($65) + TIdAnsiChar($72) + TIdAnsiChar($20) + TIdAnsiChar($73) + TIdAnsiChar($65) + TIdAnsiChar($63) + TIdAnsiChar($72) + TIdAnsiChar($65) + TIdAnsiChar($74);

type
  (* TLS Session Ticket extension struct *)
  tls_session_ticket_ext_st = record
    _length: TIdC_USHORT;
    data: Pointer;
  end;

    { The EXTERNALSYM directive is ignored by FPC, however, it is used by Delphi as follows:
		
  	  The EXTERNALSYM directive prevents the specified Delphi symbol from appearing in header 
	  files generated for C++. }
	  
  {$EXTERNALSYM SSL_CTX_set_tlsext_max_fragment_length} {introduced 1.1.0}
  {$EXTERNALSYM SSL_set_tlsext_max_fragment_length} {introduced 1.1.0}
  {$EXTERNALSYM SSL_get_servername}
  {$EXTERNALSYM SSL_get_servername_type}
  {$EXTERNALSYM SSL_export_keying_material}
  {$EXTERNALSYM SSL_export_keying_material_early} {introduced 1.1.0}
  {$EXTERNALSYM SSL_get_peer_signature_type_nid} {introduced 1.1.0}
  {$EXTERNALSYM SSL_get_signature_type_nid} {introduced 1.1.0}
  {$EXTERNALSYM SSL_get_sigalgs}
  {$EXTERNALSYM SSL_get_shared_sigalgs}

{$IFNDEF OPENSSL_STATIC_LINK_MODEL}
var
  {$EXTERNALSYM SSL_set_tlsext_host_name} {removed 1.0.0}
  SSL_set_tlsext_host_name: function (s: PSSL; const name: PIdAnsiChar): TIdC_LONG; cdecl = nil; {removed 1.0.0}

  SSL_CTX_set_tlsext_max_fragment_length: function (ctx: PSSL_CTx; mode: TIdC_UINT8): TIdC_INT; cdecl = nil; {introduced 1.1.0}
  SSL_set_tlsext_max_fragment_length: function (ssl: PSSL; mode: TIdC_UINT8): TIdC_INT; cdecl = nil; {introduced 1.1.0}

  SSL_get_servername: function (const s: PSSL; const type_: TIdC_INT): PIdAnsiChar; cdecl = nil;
  SSL_get_servername_type: function (const s: PSSL): TIdC_INT; cdecl = nil;
  (*
   * SSL_export_keying_material exports a value derived from the master secret,
   * as specified in RFC 5705. It writes |olen| bytes to |out| given a label and
   * optional context. (Since a zero length context is allowed, the |use_context|
   * flag controls whether a context is included.) It returns 1 on success and
   * 0 or -1 otherwise.
   *)
  SSL_export_keying_material: function (s: PSSL; out_: PByte; olen: TIdC_SIZET; const label_: PIdAnsiChar; llen: TIdC_SIZET; const context: PByte; contextlen: TIdC_SIZET; use_context: TIdC_INT): TIdC_INT; cdecl = nil;

  (*
   * SSL_export_keying_material_early exports a value derived from the
   * early exporter master secret, as specified in
   * https://tools.ietf.org/html/draft-ietf-tls-tls13-23. It writes
   * |olen| bytes to |out| given a label and optional context. It
   * returns 1 on success and 0 otherwise.
   *)
  SSL_export_keying_material_early: function (s: PSSL; out_: PByte; olen: TIdC_SIZET; const label_: PIdAnsiChar; llen: TIdC_SIZET; const context: PByte; contextlen: TIdC_SIZET): TIdC_INT; cdecl = nil; {introduced 1.1.0}

  SSL_get_peer_signature_type_nid: function (const s: PSSl; pnid: PIdC_INT): TIdC_INT; cdecl = nil; {introduced 1.1.0}
  SSL_get_signature_type_nid: function (const s: PSSl; pnid: PIdC_INT): TIdC_INT; cdecl = nil; {introduced 1.1.0}
  SSL_get_sigalgs: function (s: PSSl; idx: TIdC_INT; psign: PIdC_INT; phash: PIdC_INT; psignandhash: PIdC_INT; rsig: PByte; rhash: PByte): TIdC_INT; cdecl = nil;
  SSL_get_shared_sigalgs: function (s: PSSl; idx: TIdC_INT; psign: PIdC_INT; phash: PIdC_INT; psignandhash: PIdC_INT; rsig: PByte; rhash: PByte): TIdC_INT; cdecl = nil;

  //__owur TIdC_INT SSL_check_chain(s: PSSL, X509 *x, EVP_PKEY *pk, STACK_OF(X509) *chain);

  //# define SSL_set_tlsext_debug_callback(ssl, cb) \
  //        SSL_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_DEBUG_CB,\
  //                (void (*)(void))cb)

  //# define SSL_set_tlsext_debug_arg(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_DEBUG_ARG,0,arg)
  //
  //# define SSL_get_tlsext_status_type(ssl) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0,NULL)
  //
  //# define SSL_set_tlsext_status_type(ssl, type) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,type,NULL)
  //
  //# define SSL_get_tlsext_status_exts(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS,0,arg)
  //
  //# define SSL_set_tlsext_status_exts(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS,0,arg)
  //
  //# define SSL_get_tlsext_status_ids(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS,0,arg)
  //
  //# define SSL_set_tlsext_status_ids(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS,0,arg)
  //
  //# define SSL_get_tlsext_status_ocsp_resp(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP,0,arg)
  //
  //# define SSL_set_tlsext_status_ocsp_resp(ssl, arg, arglen) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP,arglen,arg)
  //
  //# define SSL_CTX_set_tlsext_servername_callback(ctx, cb) \
  //        SSL_CTX_callback_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_CB,\
  //                (void (*)(void))cb)

  //# define SSL_CTX_set_tlsext_servername_arg(ctx, arg) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG,0,arg)
  //
  //# define SSL_CTX_get_tlsext_ticket_keys(ctx, keys, keylen) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_GET_TLSEXT_TICKET_KEYS,keylen,keys)
  //# define SSL_CTX_set_tlsext_ticket_keys(ctx, keys, keylen) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_TICKET_KEYS,keylen,keys)
  //
  //# define SSL_CTX_get_tlsext_status_cb(ssl, cb) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB,0,(void *)cb)
  //# define SSL_CTX_set_tlsext_status_cb(ssl, cb) \
  //        SSL_CTX_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB,\
  //                (void (*)(void))cb)

  //# define SSL_CTX_get_tlsext_status_arg(ssl, arg) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG,0,arg)
  //# define SSL_CTX_set_tlsext_status_arg(ssl, arg) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG,0,arg)
  //
  //# define SSL_CTX_set_tlsext_status_type(ssl, type) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,type,NULL)
  //
  //# define SSL_CTX_get_tlsext_status_type(ssl) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0,NULL)
  //
  //# define SSL_CTX_set_tlsext_ticket_key_cb(ssl, cb) \
  //        SSL_CTX_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB,\
  //                (void (*)(void))cb)

{$ELSE}

  function SSL_CTX_set_tlsext_max_fragment_length(ctx: PSSL_CTx; mode: TIdC_UINT8): TIdC_INT cdecl; external CLibSSL; {introduced 1.1.0}
  function SSL_set_tlsext_max_fragment_length(ssl: PSSL; mode: TIdC_UINT8): TIdC_INT cdecl; external CLibSSL; {introduced 1.1.0}

  function SSL_get_servername(const s: PSSL; const type_: TIdC_INT): PIdAnsiChar cdecl; external CLibSSL;
  function SSL_get_servername_type(const s: PSSL): TIdC_INT cdecl; external CLibSSL;
  (*
   * SSL_export_keying_material exports a value derived from the master secret,
   * as specified in RFC 5705. It writes |olen| bytes to |out| given a label and
   * optional context. (Since a zero length context is allowed, the |use_context|
   * flag controls whether a context is included.) It returns 1 on success and
   * 0 or -1 otherwise.
   *)
  function SSL_export_keying_material(s: PSSL; out_: PByte; olen: TIdC_SIZET; const label_: PIdAnsiChar; llen: TIdC_SIZET; const context: PByte; contextlen: TIdC_SIZET; use_context: TIdC_INT): TIdC_INT cdecl; external CLibSSL;

  (*
   * SSL_export_keying_material_early exports a value derived from the
   * early exporter master secret, as specified in
   * https://tools.ietf.org/html/draft-ietf-tls-tls13-23. It writes
   * |olen| bytes to |out| given a label and optional context. It
   * returns 1 on success and 0 otherwise.
   *)
  function SSL_export_keying_material_early(s: PSSL; out_: PByte; olen: TIdC_SIZET; const label_: PIdAnsiChar; llen: TIdC_SIZET; const context: PByte; contextlen: TIdC_SIZET): TIdC_INT cdecl; external CLibSSL; {introduced 1.1.0}

  function SSL_get_peer_signature_type_nid(const s: PSSl; pnid: PIdC_INT): TIdC_INT cdecl; external CLibSSL; {introduced 1.1.0}
  function SSL_get_signature_type_nid(const s: PSSl; pnid: PIdC_INT): TIdC_INT cdecl; external CLibSSL; {introduced 1.1.0}
  function SSL_get_sigalgs(s: PSSl; idx: TIdC_INT; psign: PIdC_INT; phash: PIdC_INT; psignandhash: PIdC_INT; rsig: PByte; rhash: PByte): TIdC_INT cdecl; external CLibSSL;
  function SSL_get_shared_sigalgs(s: PSSl; idx: TIdC_INT; psign: PIdC_INT; phash: PIdC_INT; psignandhash: PIdC_INT; rsig: PByte; rhash: PByte): TIdC_INT cdecl; external CLibSSL;

  //__owur TIdC_INT SSL_check_chain(s: PSSL, X509 *x, EVP_PKEY *pk, STACK_OF(X509) *chain);

  //# define SSL_set_tlsext_debug_callback(ssl, cb) \
  //        SSL_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_DEBUG_CB,\
  //                (void (*)(void))cb)

  //# define SSL_set_tlsext_debug_arg(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_DEBUG_ARG,0,arg)
  //
  //# define SSL_get_tlsext_status_type(ssl) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0,NULL)
  //
  //# define SSL_set_tlsext_status_type(ssl, type) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,type,NULL)
  //
  //# define SSL_get_tlsext_status_exts(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS,0,arg)
  //
  //# define SSL_set_tlsext_status_exts(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS,0,arg)
  //
  //# define SSL_get_tlsext_status_ids(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS,0,arg)
  //
  //# define SSL_set_tlsext_status_ids(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS,0,arg)
  //
  //# define SSL_get_tlsext_status_ocsp_resp(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP,0,arg)
  //
  //# define SSL_set_tlsext_status_ocsp_resp(ssl, arg, arglen) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP,arglen,arg)
  //
  //# define SSL_CTX_set_tlsext_servername_callback(ctx, cb) \
  //        SSL_CTX_callback_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_CB,\
  //                (void (*)(void))cb)

  //# define SSL_CTX_set_tlsext_servername_arg(ctx, arg) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG,0,arg)
  //
  //# define SSL_CTX_get_tlsext_ticket_keys(ctx, keys, keylen) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_GET_TLSEXT_TICKET_KEYS,keylen,keys)
  //# define SSL_CTX_set_tlsext_ticket_keys(ctx, keys, keylen) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_TICKET_KEYS,keylen,keys)
  //
  //# define SSL_CTX_get_tlsext_status_cb(ssl, cb) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB,0,(void *)cb)
  //# define SSL_CTX_set_tlsext_status_cb(ssl, cb) \
  //        SSL_CTX_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB,\
  //                (void (*)(void))cb)

  //# define SSL_CTX_get_tlsext_status_arg(ssl, arg) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG,0,arg)
  //# define SSL_CTX_set_tlsext_status_arg(ssl, arg) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG,0,arg)
  //
  //# define SSL_CTX_set_tlsext_status_type(ssl, type) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,type,NULL)
  //
  //# define SSL_CTX_get_tlsext_status_type(ssl) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0,NULL)
  //
  //# define SSL_CTX_set_tlsext_ticket_key_cb(ssl, cb) \
  //        SSL_CTX_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB,\
  //                (void (*)(void))cb)

function SSL_set_tlsext_host_name(s: PSSL; const name: PIdAnsiChar): TIdC_LONG; {removed 1.0.0}
{$ENDIF}

type
  SSL_CTX_set_tlsext_servername_callback_cb = function (ssl : PSSL; alert : PIdC_INT; arg : Pointer) : TIdC_INT; cdecl;

function SSL_CTX_set_tlsext_servername_callback(ctx : PSSL_CTX; cb : SSL_CTX_set_tlsext_servername_callback_cb) : TIdC_LONG;
function SSL_CTX_set_tlsext_servername_arg(ctx : PSSL_CTX; arg : Pointer)  : TIdC_LONG;

implementation

uses 
  {$IFNDEF OPENSSL_STATIC_LINK_MODEL}
  classes,
  TaurusTLSLoader,
  {$ENDIF}
  TaurusTLSExceptionHandlers,
  TaurusTLSHeaders_ssl;

  //# define SSL_CTX_set_tlsext_servername_callback(ctx, cb) \
  //        SSL_CTX_callback_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_CB,\
  //                (void (*)(void))cb)

function SSL_CTX_set_tlsext_servername_callback(ctx : PSSL_CTX;
  cb : SSL_CTX_set_tlsext_servername_callback_cb) : TIdC_LONG;
{$IFDEF USE_INLINE}inline; {$ENDIF}
begin
  {This AV's for some reason}
  Result :=  SSL_CTX_callback_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_CB,SSL_CTX_callback_ctrl_v3(cb));
end;


  //# define SSL_CTX_set_tlsext_servername_arg(ctx, arg) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG,0,arg)
  //
function SSL_CTX_set_tlsext_servername_arg(ctx : PSSL_CTX; arg : Pointer)  : TIdC_LONG;
{$IFDEF USE_INLINE}inline; {$ENDIF}
begin
  Result := SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG,0,arg);
end;

const
  SSL_CTX_set_tlsext_max_fragment_length_introduced = (byte(1) shl 8 or byte(1)) shl 8 or byte(0);
  SSL_set_tlsext_max_fragment_length_introduced = (byte(1) shl 8 or byte(1)) shl 8 or byte(0);
  SSL_export_keying_material_early_introduced = (byte(1) shl 8 or byte(1)) shl 8 or byte(0);
  SSL_get_peer_signature_type_nid_introduced = (byte(1) shl 8 or byte(1)) shl 8 or byte(0);
  SSL_get_signature_type_nid_introduced = (byte(1) shl 8 or byte(1)) shl 8 or byte(0);
  SSL_set_tlsext_host_name_removed = (byte(1) shl 8 or byte(0)) shl 8 or byte(0);


//# define SSL_set_tlsext_host_name(s,name)         SSL_ctrl(s,SSL_CTRL_SET_TLSEXT_HOSTNAME,TLSEXT_NAMETYPE_host_name, (void *)name)
{$IFNDEF OPENSSL_STATIC_LINK_MODEL}
const
  SSL_set_tlsext_host_name_procname = 'SSL_set_tlsext_host_name'; {removed 1.0.0}

  SSL_CTX_set_tlsext_max_fragment_length_procname = 'SSL_CTX_set_tlsext_max_fragment_length'; {introduced 1.1.0}
  SSL_set_tlsext_max_fragment_length_procname = 'SSL_set_tlsext_max_fragment_length'; {introduced 1.1.0}

  SSL_get_servername_procname = 'SSL_get_servername';
  SSL_get_servername_type_procname = 'SSL_get_servername_type';
  (*
   * SSL_export_keying_material exports a value derived from the master secret,
   * as specified in RFC 5705. It writes |olen| bytes to |out| given a label and
   * optional context. (Since a zero length context is allowed, the |use_context|
   * flag controls whether a context is included.) It returns 1 on success and
   * 0 or -1 otherwise.
   *)
  SSL_export_keying_material_procname = 'SSL_export_keying_material';

  (*
   * SSL_export_keying_material_early exports a value derived from the
   * early exporter master secret, as specified in
   * https://tools.ietf.org/html/draft-ietf-tls-tls13-23. It writes
   * |olen| bytes to |out| given a label and optional context. It
   * returns 1 on success and 0 otherwise.
   *)
  SSL_export_keying_material_early_procname = 'SSL_export_keying_material_early'; {introduced 1.1.0}

  SSL_get_peer_signature_type_nid_procname = 'SSL_get_peer_signature_type_nid'; {introduced 1.1.0}
  SSL_get_signature_type_nid_procname = 'SSL_get_signature_type_nid'; {introduced 1.1.0}
  SSL_get_sigalgs_procname = 'SSL_get_sigalgs';
  SSL_get_shared_sigalgs_procname = 'SSL_get_shared_sigalgs';

  //__owur TIdC_INT SSL_check_chain(s: PSSL, X509 *x, EVP_PKEY *pk, STACK_OF(X509) *chain);

  //# define SSL_set_tlsext_debug_callback(ssl, cb) \
  //        SSL_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_DEBUG_CB,\
  //                (void (*)(void))cb)

  //# define SSL_set_tlsext_debug_arg(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_DEBUG_ARG,0,arg)
  //
  //# define SSL_get_tlsext_status_type(ssl) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0,NULL)
  //
  //# define SSL_set_tlsext_status_type(ssl, type) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,type,NULL)
  //
  //# define SSL_get_tlsext_status_exts(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS,0,arg)
  //
  //# define SSL_set_tlsext_status_exts(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS,0,arg)
  //
  //# define SSL_get_tlsext_status_ids(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS,0,arg)
  //
  //# define SSL_set_tlsext_status_ids(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS,0,arg)
  //
  //# define SSL_get_tlsext_status_ocsp_resp(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP,0,arg)
  //
  //# define SSL_set_tlsext_status_ocsp_resp(ssl, arg, arglen) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP,arglen,arg)
  //




  //# define SSL_CTX_get_tlsext_ticket_keys(ctx, keys, keylen) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_GET_TLSEXT_TICKET_KEYS,keylen,keys)
  //# define SSL_CTX_set_tlsext_ticket_keys(ctx, keys, keylen) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_TICKET_KEYS,keylen,keys)
  //
  //# define SSL_CTX_get_tlsext_status_cb(ssl, cb) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB,0,(void *)cb)
  //# define SSL_CTX_set_tlsext_status_cb(ssl, cb) \
  //        SSL_CTX_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB,\
  //                (void (*)(void))cb)

  //# define SSL_CTX_get_tlsext_status_arg(ssl, arg) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG,0,arg)
  //# define SSL_CTX_set_tlsext_status_arg(ssl, arg) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG,0,arg)
  //
  //# define SSL_CTX_set_tlsext_status_type(ssl, type) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,type,NULL)
  //
  //# define SSL_CTX_get_tlsext_status_type(ssl) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0,NULL)
  //
  //# define SSL_CTX_set_tlsext_ticket_key_cb(ssl, cb) \
  //        SSL_CTX_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB,\
  //                (void (*)(void))cb)



//# define SSL_set_tlsext_host_name(s,name)         SSL_ctrl(s,SSL_CTRL_SET_TLSEXT_HOSTNAME,TLSEXT_NAMETYPE_host_name, (void *)name)
function  _SSL_set_tlsext_host_name(s: PSSL; const name: PIdAnsiChar): TIdC_LONG; cdecl;
begin
  Result := SSL_ctrl(s, SSL_CTRL_SET_TLSEXT_HOSTNAME, TLSEXT_NAMETYPE_host_name, Pointer(name));
end;

  {$I TaurusTLSNoRetValOff.inc} 

function  ERR_SSL_set_tlsext_host_name(s: PSSL; const name: PIdAnsiChar): TIdC_LONG;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_set_tlsext_host_name_procname);
end;



function  ERR_SSL_CTX_set_tlsext_max_fragment_length(ctx: PSSL_CTx; mode: TIdC_UINT8): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_CTX_set_tlsext_max_fragment_length_procname);
end;

 {introduced 1.1.0}
function  ERR_SSL_set_tlsext_max_fragment_length(ssl: PSSL; mode: TIdC_UINT8): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_set_tlsext_max_fragment_length_procname);
end;

 {introduced 1.1.0}

function  ERR_SSL_get_servername(const s: PSSL; const type_: TIdC_INT): PIdAnsiChar;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_get_servername_procname);
end;


function  ERR_SSL_get_servername_type(const s: PSSL): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_get_servername_type_procname);
end;


  (*
   * SSL_export_keying_material exports a value derived from the master secret,
   * as specified in RFC 5705. It writes |olen| bytes to |out| given a label and
   * optional context. (Since a zero length context is allowed, the |use_context|
   * flag controls whether a context is included.) It returns 1 on success and
   * 0 or -1 otherwise.
   *)
function  ERR_SSL_export_keying_material(s: PSSL; out_: PByte; olen: TIdC_SIZET; const label_: PIdAnsiChar; llen: TIdC_SIZET; const context: PByte; contextlen: TIdC_SIZET; use_context: TIdC_INT): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_export_keying_material_procname);
end;



  (*
   * SSL_export_keying_material_early exports a value derived from the
   * early exporter master secret, as specified in
   * https://tools.ietf.org/html/draft-ietf-tls-tls13-23. It writes
   * |olen| bytes to |out| given a label and optional context. It
   * returns 1 on success and 0 otherwise.
   *)
function  ERR_SSL_export_keying_material_early(s: PSSL; out_: PByte; olen: TIdC_SIZET; const label_: PIdAnsiChar; llen: TIdC_SIZET; const context: PByte; contextlen: TIdC_SIZET): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_export_keying_material_early_procname);
end;

 {introduced 1.1.0}

function  ERR_SSL_get_peer_signature_type_nid(const s: PSSl; pnid: PIdC_INT): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_get_peer_signature_type_nid_procname);
end;

 {introduced 1.1.0}
function  ERR_SSL_get_signature_type_nid(const s: PSSl; pnid: PIdC_INT): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_get_signature_type_nid_procname);
end;

 {introduced 1.1.0}
function  ERR_SSL_get_sigalgs(s: PSSl; idx: TIdC_INT; psign: PIdC_INT; phash: PIdC_INT; psignandhash: PIdC_INT; rsig: PByte; rhash: PByte): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_get_sigalgs_procname);
end;


function  ERR_SSL_get_shared_sigalgs(s: PSSl; idx: TIdC_INT; psign: PIdC_INT; phash: PIdC_INT; psignandhash: PIdC_INT; rsig: PByte; rhash: PByte): TIdC_INT;  cdecl;
begin
  ETaurusTLSAPIFunctionNotPresent.RaiseException(SSL_get_shared_sigalgs_procname);
end;



  //__owur TIdC_INT SSL_check_chain(s: PSSL, X509 *x, EVP_PKEY *pk, STACK_OF(X509) *chain);

  //# define SSL_set_tlsext_debug_callback(ssl, cb) \
  //        SSL_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_DEBUG_CB,\
  //                (void (*)(void))cb)

  //# define SSL_set_tlsext_debug_arg(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_DEBUG_ARG,0,arg)
  //
  //# define SSL_get_tlsext_status_type(ssl) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0,NULL)
  //
  //# define SSL_set_tlsext_status_type(ssl, type) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,type,NULL)
  //
  //# define SSL_get_tlsext_status_exts(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS,0,arg)
  //
  //# define SSL_set_tlsext_status_exts(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS,0,arg)
  //
  //# define SSL_get_tlsext_status_ids(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS,0,arg)
  //
  //# define SSL_set_tlsext_status_ids(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS,0,arg)
  //
  //# define SSL_get_tlsext_status_ocsp_resp(ssl, arg) \
  //        SSL_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP,0,arg)
  //
  //# define SSL_set_tlsext_status_ocsp_resp(ssl, arg, arglen) \
  //        SSL_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP,arglen,arg)
  //
  //# define SSL_CTX_set_tlsext_servername_callback(ctx, cb) \
  //        SSL_CTX_callback_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_CB,\
  //                (void (*)(void))cb)

  //# define SSL_CTX_set_tlsext_servername_arg(ctx, arg) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG,0,arg)
  //
  //# define SSL_CTX_get_tlsext_ticket_keys(ctx, keys, keylen) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_GET_TLSEXT_TICKET_KEYS,keylen,keys)
  //# define SSL_CTX_set_tlsext_ticket_keys(ctx, keys, keylen) \
  //        SSL_CTX_ctrl(ctx,SSL_CTRL_SET_TLSEXT_TICKET_KEYS,keylen,keys)
  //
  //# define SSL_CTX_get_tlsext_status_cb(ssl, cb) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB,0,(void *)cb)
  //# define SSL_CTX_set_tlsext_status_cb(ssl, cb) \
  //        SSL_CTX_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB,\
  //                (void (*)(void))cb)

  //# define SSL_CTX_get_tlsext_status_arg(ssl, arg) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG,0,arg)
  //# define SSL_CTX_set_tlsext_status_arg(ssl, arg) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG,0,arg)
  //
  //# define SSL_CTX_set_tlsext_status_type(ssl, type) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,type,NULL)
  //
  //# define SSL_CTX_get_tlsext_status_type(ssl) \
  //        SSL_CTX_ctrl(ssl,SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0,NULL)
  //
  //# define SSL_CTX_set_tlsext_ticket_key_cb(ssl, cb) \
  //        SSL_CTX_callback_ctrl(ssl,SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB,\
  //                (void (*)(void))cb)


  {$I TaurusTLSNoRetValOn.inc} 

procedure Load(const ADllHandle: TIdLibHandle; LibVersion: TIdC_UINT; const AFailed: TStringList);

var FuncLoadError: boolean;

begin
  SSL_set_tlsext_host_name := LoadLibFunction(ADllHandle, SSL_set_tlsext_host_name_procname);
  FuncLoadError := not assigned(SSL_set_tlsext_host_name);
  if FuncLoadError then
  begin
    {$if not defined(SSL_set_tlsext_host_name_allownil)}
    SSL_set_tlsext_host_name := ERR_SSL_set_tlsext_host_name;
    {$ifend}
    {$if declared(SSL_set_tlsext_host_name_introduced)}
    if LibVersion < SSL_set_tlsext_host_name_introduced then
    begin
      {$if declared(FC_SSL_set_tlsext_host_name)}
      SSL_set_tlsext_host_name := FC_SSL_set_tlsext_host_name;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_set_tlsext_host_name_removed)}
    if SSL_set_tlsext_host_name_removed <= LibVersion then
    begin
      {$if declared(_SSL_set_tlsext_host_name)}
      SSL_set_tlsext_host_name := _SSL_set_tlsext_host_name;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_set_tlsext_host_name_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_set_tlsext_host_name');
    {$ifend}
  end;

 
  SSL_CTX_set_tlsext_max_fragment_length := LoadLibFunction(ADllHandle, SSL_CTX_set_tlsext_max_fragment_length_procname);
  FuncLoadError := not assigned(SSL_CTX_set_tlsext_max_fragment_length);
  if FuncLoadError then
  begin
    {$if not defined(SSL_CTX_set_tlsext_max_fragment_length_allownil)}
    SSL_CTX_set_tlsext_max_fragment_length := ERR_SSL_CTX_set_tlsext_max_fragment_length;
    {$ifend}
    {$if declared(SSL_CTX_set_tlsext_max_fragment_length_introduced)}
    if LibVersion < SSL_CTX_set_tlsext_max_fragment_length_introduced then
    begin
      {$if declared(FC_SSL_CTX_set_tlsext_max_fragment_length)}
      SSL_CTX_set_tlsext_max_fragment_length := FC_SSL_CTX_set_tlsext_max_fragment_length;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_CTX_set_tlsext_max_fragment_length_removed)}
    if SSL_CTX_set_tlsext_max_fragment_length_removed <= LibVersion then
    begin
      {$if declared(_SSL_CTX_set_tlsext_max_fragment_length)}
      SSL_CTX_set_tlsext_max_fragment_length := _SSL_CTX_set_tlsext_max_fragment_length;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_CTX_set_tlsext_max_fragment_length_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_CTX_set_tlsext_max_fragment_length');
    {$ifend}
  end;

 {introduced 1.1.0}
  SSL_set_tlsext_max_fragment_length := LoadLibFunction(ADllHandle, SSL_set_tlsext_max_fragment_length_procname);
  FuncLoadError := not assigned(SSL_set_tlsext_max_fragment_length);
  if FuncLoadError then
  begin
    {$if not defined(SSL_set_tlsext_max_fragment_length_allownil)}
    SSL_set_tlsext_max_fragment_length := ERR_SSL_set_tlsext_max_fragment_length;
    {$ifend}
    {$if declared(SSL_set_tlsext_max_fragment_length_introduced)}
    if LibVersion < SSL_set_tlsext_max_fragment_length_introduced then
    begin
      {$if declared(FC_SSL_set_tlsext_max_fragment_length)}
      SSL_set_tlsext_max_fragment_length := FC_SSL_set_tlsext_max_fragment_length;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_set_tlsext_max_fragment_length_removed)}
    if SSL_set_tlsext_max_fragment_length_removed <= LibVersion then
    begin
      {$if declared(_SSL_set_tlsext_max_fragment_length)}
      SSL_set_tlsext_max_fragment_length := _SSL_set_tlsext_max_fragment_length;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_set_tlsext_max_fragment_length_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_set_tlsext_max_fragment_length');
    {$ifend}
  end;

 {introduced 1.1.0}
  SSL_get_servername := LoadLibFunction(ADllHandle, SSL_get_servername_procname);
  FuncLoadError := not assigned(SSL_get_servername);
  if FuncLoadError then
  begin
    {$if not defined(SSL_get_servername_allownil)}
    SSL_get_servername := ERR_SSL_get_servername;
    {$ifend}
    {$if declared(SSL_get_servername_introduced)}
    if LibVersion < SSL_get_servername_introduced then
    begin
      {$if declared(FC_SSL_get_servername)}
      SSL_get_servername := FC_SSL_get_servername;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_get_servername_removed)}
    if SSL_get_servername_removed <= LibVersion then
    begin
      {$if declared(_SSL_get_servername)}
      SSL_get_servername := _SSL_get_servername;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_get_servername_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_get_servername');
    {$ifend}
  end;


  SSL_get_servername_type := LoadLibFunction(ADllHandle, SSL_get_servername_type_procname);
  FuncLoadError := not assigned(SSL_get_servername_type);
  if FuncLoadError then
  begin
    {$if not defined(SSL_get_servername_type_allownil)}
    SSL_get_servername_type := ERR_SSL_get_servername_type;
    {$ifend}
    {$if declared(SSL_get_servername_type_introduced)}
    if LibVersion < SSL_get_servername_type_introduced then
    begin
      {$if declared(FC_SSL_get_servername_type)}
      SSL_get_servername_type := FC_SSL_get_servername_type;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_get_servername_type_removed)}
    if SSL_get_servername_type_removed <= LibVersion then
    begin
      {$if declared(_SSL_get_servername_type)}
      SSL_get_servername_type := _SSL_get_servername_type;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_get_servername_type_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_get_servername_type');
    {$ifend}
  end;


  SSL_export_keying_material := LoadLibFunction(ADllHandle, SSL_export_keying_material_procname);
  FuncLoadError := not assigned(SSL_export_keying_material);
  if FuncLoadError then
  begin
    {$if not defined(SSL_export_keying_material_allownil)}
    SSL_export_keying_material := ERR_SSL_export_keying_material;
    {$ifend}
    {$if declared(SSL_export_keying_material_introduced)}
    if LibVersion < SSL_export_keying_material_introduced then
    begin
      {$if declared(FC_SSL_export_keying_material)}
      SSL_export_keying_material := FC_SSL_export_keying_material;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_export_keying_material_removed)}
    if SSL_export_keying_material_removed <= LibVersion then
    begin
      {$if declared(_SSL_export_keying_material)}
      SSL_export_keying_material := _SSL_export_keying_material;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_export_keying_material_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_export_keying_material');
    {$ifend}
  end;


  SSL_export_keying_material_early := LoadLibFunction(ADllHandle, SSL_export_keying_material_early_procname);
  FuncLoadError := not assigned(SSL_export_keying_material_early);
  if FuncLoadError then
  begin
    {$if not defined(SSL_export_keying_material_early_allownil)}
    SSL_export_keying_material_early := ERR_SSL_export_keying_material_early;
    {$ifend}
    {$if declared(SSL_export_keying_material_early_introduced)}
    if LibVersion < SSL_export_keying_material_early_introduced then
    begin
      {$if declared(FC_SSL_export_keying_material_early)}
      SSL_export_keying_material_early := FC_SSL_export_keying_material_early;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_export_keying_material_early_removed)}
    if SSL_export_keying_material_early_removed <= LibVersion then
    begin
      {$if declared(_SSL_export_keying_material_early)}
      SSL_export_keying_material_early := _SSL_export_keying_material_early;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_export_keying_material_early_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_export_keying_material_early');
    {$ifend}
  end;

 {introduced 1.1.0}
  SSL_get_peer_signature_type_nid := LoadLibFunction(ADllHandle, SSL_get_peer_signature_type_nid_procname);
  FuncLoadError := not assigned(SSL_get_peer_signature_type_nid);
  if FuncLoadError then
  begin
    {$if not defined(SSL_get_peer_signature_type_nid_allownil)}
    SSL_get_peer_signature_type_nid := ERR_SSL_get_peer_signature_type_nid;
    {$ifend}
    {$if declared(SSL_get_peer_signature_type_nid_introduced)}
    if LibVersion < SSL_get_peer_signature_type_nid_introduced then
    begin
      {$if declared(FC_SSL_get_peer_signature_type_nid)}
      SSL_get_peer_signature_type_nid := FC_SSL_get_peer_signature_type_nid;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_get_peer_signature_type_nid_removed)}
    if SSL_get_peer_signature_type_nid_removed <= LibVersion then
    begin
      {$if declared(_SSL_get_peer_signature_type_nid)}
      SSL_get_peer_signature_type_nid := _SSL_get_peer_signature_type_nid;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_get_peer_signature_type_nid_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_get_peer_signature_type_nid');
    {$ifend}
  end;

 {introduced 1.1.0}
  SSL_get_signature_type_nid := LoadLibFunction(ADllHandle, SSL_get_signature_type_nid_procname);
  FuncLoadError := not assigned(SSL_get_signature_type_nid);
  if FuncLoadError then
  begin
    {$if not defined(SSL_get_signature_type_nid_allownil)}
    SSL_get_signature_type_nid := ERR_SSL_get_signature_type_nid;
    {$ifend}
    {$if declared(SSL_get_signature_type_nid_introduced)}
    if LibVersion < SSL_get_signature_type_nid_introduced then
    begin
      {$if declared(FC_SSL_get_signature_type_nid)}
      SSL_get_signature_type_nid := FC_SSL_get_signature_type_nid;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_get_signature_type_nid_removed)}
    if SSL_get_signature_type_nid_removed <= LibVersion then
    begin
      {$if declared(_SSL_get_signature_type_nid)}
      SSL_get_signature_type_nid := _SSL_get_signature_type_nid;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_get_signature_type_nid_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_get_signature_type_nid');
    {$ifend}
  end;

 {introduced 1.1.0}
  SSL_get_sigalgs := LoadLibFunction(ADllHandle, SSL_get_sigalgs_procname);
  FuncLoadError := not assigned(SSL_get_sigalgs);
  if FuncLoadError then
  begin
    {$if not defined(SSL_get_sigalgs_allownil)}
    SSL_get_sigalgs := ERR_SSL_get_sigalgs;
    {$ifend}
    {$if declared(SSL_get_sigalgs_introduced)}
    if LibVersion < SSL_get_sigalgs_introduced then
    begin
      {$if declared(FC_SSL_get_sigalgs)}
      SSL_get_sigalgs := FC_SSL_get_sigalgs;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_get_sigalgs_removed)}
    if SSL_get_sigalgs_removed <= LibVersion then
    begin
      {$if declared(_SSL_get_sigalgs)}
      SSL_get_sigalgs := _SSL_get_sigalgs;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_get_sigalgs_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_get_sigalgs');
    {$ifend}
  end;


  SSL_get_shared_sigalgs := LoadLibFunction(ADllHandle, SSL_get_shared_sigalgs_procname);
  FuncLoadError := not assigned(SSL_get_shared_sigalgs);
  if FuncLoadError then
  begin
    {$if not defined(SSL_get_shared_sigalgs_allownil)}
    SSL_get_shared_sigalgs := ERR_SSL_get_shared_sigalgs;
    {$ifend}
    {$if declared(SSL_get_shared_sigalgs_introduced)}
    if LibVersion < SSL_get_shared_sigalgs_introduced then
    begin
      {$if declared(FC_SSL_get_shared_sigalgs)}
      SSL_get_shared_sigalgs := FC_SSL_get_shared_sigalgs;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if declared(SSL_get_shared_sigalgs_removed)}
    if SSL_get_shared_sigalgs_removed <= LibVersion then
    begin
      {$if declared(_SSL_get_shared_sigalgs)}
      SSL_get_shared_sigalgs := _SSL_get_shared_sigalgs;
      {$ifend}
      FuncLoadError := false;
    end;
    {$ifend}
    {$if not defined(SSL_get_shared_sigalgs_allownil)}
    if FuncLoadError then
      AFailed.Add('SSL_get_shared_sigalgs');
    {$ifend}
  end;


end;

procedure Unload;
begin
  SSL_set_tlsext_host_name := nil; {removed 1.0.0}
  SSL_CTX_set_tlsext_max_fragment_length := nil; {introduced 1.1.0}
  SSL_set_tlsext_max_fragment_length := nil; {introduced 1.1.0}
  SSL_get_servername := nil;
  SSL_get_servername_type := nil;
  SSL_export_keying_material := nil;
  SSL_export_keying_material_early := nil; {introduced 1.1.0}
  SSL_get_peer_signature_type_nid := nil; {introduced 1.1.0}
  SSL_get_signature_type_nid := nil; {introduced 1.1.0}
  SSL_get_sigalgs := nil;
  SSL_get_shared_sigalgs := nil;
end;
{$ELSE}
function SSL_set_tlsext_host_name(s: PSSL; const name: PIdAnsiChar): TIdC_LONG;
begin
  Result := SSL_ctrl(s, SSL_CTRL_SET_TLSEXT_HOSTNAME, TLSEXT_NAMETYPE_host_name, Pointer(name));
end;

{$ENDIF}

{$IFNDEF OPENSSL_STATIC_LINK_MODEL}
initialization
  Register_SSLLoader(Load,'LibSSL');
  Register_SSLUnloader(Unload);
{$ENDIF}
end.
