Unit AllTaurustlsReg;

Interface

Uses
  Classes,
  PropEdits,
  ComponentEditors;

Type
   TTaurusTLSComponentEditor = Class(TDefaultComponentEditor)
   Public
      Procedure ExecuteVerb(Index: Integer); Override;
      Function GetVerb(Index: Integer): String; Override;
      Function GetVerbCount: Integer; Override;
   End;

{$I TaurusTLS_Vers.inc}

Procedure Register;

Implementation

{$R AllTaurustlsReg.res}

Uses
   IdGlobal,
   TaurusTLS,
   TaurusTLS_Dsn_AboutDlg,
   TaurusTLS_Dsn_ResourceStrings;

Procedure TTaurusTLSComponentEditor.ExecuteVerb(Index: Integer);
Begin
   Case Index Of
      0: AboutDlg(gsTaurusTLSVersion);
   End;
End;

Function TTaurusTLSComponentEditor.GetVerb(Index: Integer): String;
Begin
   Case Index Of
      0: Result := IndyFormat(RSAAboutMenuItemName, [gsTaurusTLSVersion]);
   End;
End;

Function TTaurusTLSComponentEditor.GetVerbCount: Integer;
Begin
   Result := 1;
End;

Procedure Register;
Begin
   RegisterComponents('Indy TaurusTLS', [TTaurusTLSServerIOHandler, TTaurusTLSIOHandlerSocket]);

   RegisterComponentEditor(TTaurusTLSIOHandlerSocket, TTaurusTLSComponentEditor);
   RegisterComponentEditor(TTaurusTLSServerIOHandler, TTaurusTLSComponentEditor);
End;

End.
